/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "CreateTargetDialog.h"
#include "DatabaseManager.h"
#include "eWallet.h"
#include "Constants.h"
#include <QDesktopServices>



CreateTargetDialog::CreateTargetDialog(Target* target, eWallet *paTarget) :
		QDialog((QWidget*)paTarget)
{
	this->target = target;
	this->parent = paTarget;

	currentImageN = NULL;
	currentImageBackN = NULL;
	
	if (target) {
		currentImage = target->getPicture();
		currentImageBack = target->getPictureBack();
	}
	else {
		currentImage = NULL;
		currentImageBack = NULL;
	}

	setContextMenuPolicy(Qt::NoContextMenu);

	// Create dialog main layout

	layout = new QHBoxLayout(this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);


	// Create layout for the ui controls
	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);

	// Name label
	nameLabel = new QLabel("Name", this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

// Name line edit
	nameLineEdit = new QLineEdit(this);
	nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLineEdit->setAlignment(Qt::AlignTop);

	componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);

	// type label
	typeLabel = new QLabel("Type", this);
	typeLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//typeLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(typeLabel, 2, 1, 1, 2);

	// type line edit
	typeLineEdit = new QComboBox(this);
	typeLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//typeLineEdit->setAlignment(Qt::AlignTop);

	componentLayout->addWidget(typeLineEdit, 2, 3, 1, 4);

	QPixmap available(":/resources/empty_card.png");
	QPixmap availableBack(":/resources/empty_card_back.png");

	imageLabel = new QLabel(this);
	imageLabel->setContextMenuPolicy(Qt::NoContextMenu);
	imageLabel->setBackgroundRole(QPalette::NoRole);
	imageLabel->setScaledContents(true);
	//imageLabel->setFixedSize(200, 170);
	componentLayout->addWidget(imageLabel, 3, 1, 2, 3);
	imageBackLabel = new QLabel(this);
	imageBackLabel->setContextMenuPolicy(Qt::NoContextMenu);
	imageBackLabel->setBackgroundRole(QPalette::NoRole);
	imageBackLabel->setScaledContents(true);
	//imageBackLabel->setFixedSize(200, 170);
	componentLayout->addWidget(imageBackLabel, 3, 4, 2, 3);

	if (target) { // Edit curTarget Targeter
		nameLineEdit->setText (target->name);

		for(int i = 0; i < parent->types.size(); i++) {
			typeLineEdit->addItem (parent->types[i], parent->types[i]);
			if (target)
				if (target->type == parent->types[i]) {
					typeLineEdit->setCurrentIndex(i);
				}
		}

		if (currentImage != NULL)
			imageLabel->setPixmap(QPixmap::fromImage (*currentImage));
		else
			imageLabel->setPixmap(available);
		if (currentImageBack != NULL)
			imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBack));
		else
			imageBackLabel->setPixmap(availableBack);
	} 
	else {
		imageLabel->setPixmap(available);
		imageBackLabel->setPixmap(availableBack);
	}

// Add components to layout
	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	// Create buttons

	createButtons(layout);


	setLayout(layout);
	createMenu();

}

void CreateTargetDialog::createButtons(QBoxLayout* l)
{
	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	imageButton = new QPushButton(QIcon(":/resources/icon_empty_card.png"), "Card Face", this);
	imageButton->setFixedHeight(70);
	imageButton->setContextMenuPolicy(Qt::NoContextMenu);
	imageButton->setFocusPolicy(Qt::NoFocus);
	imageButton->setIconSize(QSize(48, 48));
	QObject::connect(imageButton, SIGNAL(clicked()), this, SLOT(cardFace()));
	dlgBtnBox->addButton(imageButton, QDialogButtonBox::ActionRole);

	imageBackButton = new QPushButton(QIcon(":/resources/icon_empty_card_back.png"), "Card Back", this);
	imageBackButton->setFixedHeight(70);
	imageBackButton->setContextMenuPolicy(Qt::NoContextMenu);
	imageBackButton->setFocusPolicy(Qt::NoFocus);
	imageBackButton->setIconSize(QSize(48, 48));
	QObject::connect(imageBackButton, SIGNAL(clicked()), this, SLOT(cardBack()));
	dlgBtnBox->addButton(imageBackButton, QDialogButtonBox::ActionRole);

	saveButton = new QPushButton(QIcon(":/resources/icon_save.png"), "Save", this);
	saveButton->setFixedHeight(70);
	saveButton->setContextMenuPolicy(Qt::NoContextMenu);
	saveButton->setFocusPolicy(Qt::NoFocus);
	saveButton->setIconSize(QSize(48, 48));
	QObject::connect(saveButton, SIGNAL(clicked()), this, SLOT(save()));
	dlgBtnBox->addButton(saveButton, QDialogButtonBox::ActionRole);

	deleteButton = new QPushButton(QIcon(":/resources/icon_delete.png"), "Delete", this);
	deleteButton->setFixedHeight(70);
	deleteButton->setContextMenuPolicy(Qt::NoContextMenu);
	deleteButton->setFocusPolicy(Qt::NoFocus);
	deleteButton->setIconSize(QSize(48, 48));
	QObject::connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteTarget()));
	dlgBtnBox->addButton(deleteButton, QDialogButtonBox::ActionRole);

	l->addWidget(dlgBtnBox);
	l->setAlignment(dlgBtnBox, Qt::AlignBottom);
}

void CreateTargetDialog::createMenu()
{
#if defined(Q_OS_WIN32)
	menuBar = new QMenuBar(this);
	QMenu* optionsMenu = menuBar->addMenu(tr("&File"));
	optionsMenu->addAction("Save", this, SLOT(save()));
	optionsMenu->addAction("Cancel", this, SLOT(close()));
	optionsMenu->addAction("Delete", this, SLOT(deleteTarget()));
	optionsMenu->addAction("Back", this, SLOT(close()));
	layout()->setMenuBar(menuBar);
#endif
}

CreateTargetDialog::~CreateTargetDialog()
{
	if (currentImageBackN) delete currentImageBackN;
	if (currentImageN) delete currentImageN;
}

void CreateTargetDialog::deleteTarget()
{
	if (target)
		parent->deleteTarget(target);

	close();
}

void CreateTargetDialog::loadImage (QString q, QImage& res) {
	QImageReader reader;
	// Set image name
/*	QString path(QDir::home().path());
	path.append(QDir::separator()).append("photo.png");
	path = QDir::toNativeSeparators(path);
*/
	reader.setFileName(q);
	//Set/scale image size into screen
	QSize imageSize = reader.size();
	QSize ss (INTERNAL_WIDTH, INTERNAL_HEIGH);
	imageSize.scale(ss, Qt::KeepAspectRatio);
	reader.setScaledSize(ss);
	// Read image
	res = reader.read();
	//qDebug () << "read " << q << " as (" << imageSize << ") with result " << reader.errorString ();
}

void CreateTargetDialog::cardFace()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card face image",
	                path,
	                "Images (*.png *.jpg)");

	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageN) delete currentImageN;

		/*QImage * tmp = new QImage (s);
		currentImageN = new QImage ();
		*currentImageN = tmp->scaled (INTERNAL_WIDTH, INTERNAL_HEIGH);
		delete tmp;
		*/
		currentImageN = new QImage ();
		loadImage(s, *currentImageN); //;
		//qDebug () << "loaded " << s;
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		//qDebug () << "asigned " << s;
		//update();
	}
}
void CreateTargetDialog::cardBack()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card back image",
	                path,
	                "Images (*.png *.jpg)");
	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageBackN) delete currentImageBackN;
		
		/*QImage * tmp = new QImage (s);
		currentImageBackN = new QImage ();
		*currentImageBackN = tmp->scaled (INTERNAL_WIDTH, INTERNAL_HEIGH);
		delete tmp;
		*/
		currentImageBackN = new QImage ();
		loadImage(s, *currentImageBackN); //;
		
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		//update ();
	}
}
/*
void CreateTargetDialog::cardFace()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card face image",
	                path,
	                "Images (*.png *.jpg)");

	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageN) delete currentImageN;
		currentImageN = new QImage (s);
		//qDebug () << "loaded " << s;
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		//qDebug () << "asigned " << s;
		//update();
	}
}
void CreateTargetDialog::cardBack()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card back image",
	                path,
	                "Images (*.png *.jpg)");
	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageBackN) delete currentImageBackN;
		currentImageBackN = new QImage (s);
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		//update ();
	}
}
 * */
void CreateTargetDialog::save()
{
	// Name have to set
	if (nameLineEdit->text().length() < 1) {
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", "Card description is missing", QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
		return;
	}

	/*if (typeLineEdit->text().length() < 1) {
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", "Type card is missing", QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
		return;
	}*/

	// Create new or edit
	if (target) {
		// Edit
		//dataMapper->submit();
		target->name = nameLineEdit->text();
		target->type = typeLineEdit->itemData(typeLineEdit->currentIndex()).toString();//typeLineEdit->text();
		if (currentImageN) {
			target->setPicture (currentImageN);
			currentImageN = NULL;
		}
		// Already loaded!
/*		else
			target->setPicture (currentImage);*/

		if (currentImageBackN) {
			target->setPictureBack (currentImageBackN);
			currentImageBackN = NULL;
		}
		// Already loaded!
/*		else
			target->setPictureBack (currentImageBack);*/
		
		parent->_updateTarget(target);

		// before free resources we calculate small image!
		target->getPictureSmall();
		target->freeResources();
	} else {
		// Create new
		// Insert Targeter
		Target * who = new Target();
		who->name = nameLineEdit->text();
		who->type = typeLineEdit->itemData(typeLineEdit->currentIndex()).toString();//typeLineEdit->text();
		who->setPicture (currentImageN);
		who->setPictureBack (currentImageBackN);
		currentImageN = NULL;
		currentImageBackN = NULL;
		
		parent->_insertTarget(who);

		who->getPictureSmall();
		who->freeResources();
	}

	close();
}
