#include "TestSettingsModel.hpp"
#include "Options.hpp"

#include "modeltest.h"

using qtplus::SettingsModel;
using qtplus::OptionsGroup;

TestSettingsModel::TestSettingsModel()
		: model_(0)
{
}


void TestSettingsModel::testAddEmptyGroups()
{
	model_.reset(new SettingsModel());
	std::auto_ptr<ModelTest> modelmon(new ModelTest(model_.get(), 0));

	QVERIFY(model_->rowCount() == 0);
	QVERIFY(model_->columnCount() == 0);
	QVERIFY(model_->data(QModelIndex()) == QVariant());
	QVERIFY(model_->data(model_->index(0, 0)) == QVariant());
	QVERIFY(model_->data(model_->index(1, 0)) == QVariant());
	QVERIFY(model_->data(model_->index(0, 1)) == QVariant());
	QVERIFY(model_->data(model_->index(1, 1)) == QVariant());

	model_->addGroup(SettingsModel::group_ptr(new OptionsGroup("Group1")));

	QVERIFY(model_->rowCount() == 1);
	QVERIFY(model_->columnCount() == 1);
	QVERIFY(model_->data(QModelIndex()) == QVariant());
	QVERIFY(model_->data(model_->index(0, 0)) == QVariant("Group1"));
	QVERIFY(model_->data(model_->index(1, 0)) == QVariant());
	QVERIFY(model_->data(model_->index(0, 1)) == QVariant());
	QVERIFY(model_->data(model_->index(1, 1)) == QVariant());


	model_->addGroup(SettingsModel::group_ptr(new OptionsGroup("Group2")));

	QVERIFY(model_->rowCount() == 2);
	QVERIFY(model_->columnCount() == 1);
	QVERIFY(model_->data(QModelIndex()) == QVariant());
	QVERIFY(model_->data(model_->index(0, 0)) == QVariant("Group1"));
	QVERIFY(model_->data(model_->index(1, 0)) == QVariant("Group2"));
	QVERIFY(model_->data(model_->index(0, 1)) == QVariant());
	QVERIFY(model_->data(model_->index(1, 1)) == QVariant());
}
