/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TEST_HPP_
#define _TEST_HPP_

#include "TorrentHandle.hpp"
#include "server.h"

#include <QObject>
#include <QString>
#include <QSharedPointer>
#include <QWeakPointer>

#include <qtrapids/dbus.hpp>

#include <libtorrent/session.hpp>
#include <libtorrent/torrent_info.hpp>
#include <libtorrent/alert_types.hpp>
#include <libtorrent/error_code.hpp>

#include <utility>

class QSettings;

namespace qtrapids
{

typedef QWeakPointer<QSettings> settings_weak_ptr;

class AlertWaiterThread;
typedef libtorrent::session session_t;
typedef libtorrent::session const* session_cptr;
typedef libtorrent::session_settings session_settings_t;

typedef libtorrent::add_torrent_params add_torrent_params_t;
typedef libtorrent::alert alert_t;
//    typedef libtorrent::alert const* alert_cptr;
typedef	libtorrent::torrent_alert torrent_alert_t;
typedef libtorrent::libtorrent_exception torrent_exception_t;

typedef QSharedPointer<TorrentHandle> TorrentHandlePtr;
typedef QHash<QString, TorrentHandlePtr > torrents_t;
typedef std::pair<int, int> ports_range_t;

class ServerDb;
class ServerSettings;

class TorrentSession : public QObject
{

	Q_OBJECT;
	Q_CLASSINFO("D-Bus Interface", "com.ixonos.qtrapids");

public:
	TorrentSession(QObject *parent, QSettings *);
	virtual ~TorrentSession();
	
public slots:
	void getState();
	void addTorrent(const QString &path, const QString &save_path
	                , qtrapids::ParamsMap_t other_params);
	void removeTorrent(const QString &hash);
	void setOptions(qtrapids::ParamsMap_t options);
	qtrapids::ParamsMap_t getOptions();
	void terminateSession();
	
signals:
	void alert(qtrapids::TorrentState info, qtrapids::ParamsMap_t other_info);
	void terminate();
	void sessionTerminated();
	
private slots:
	void on_alert();

private:

	void loadState();
	void addTorrent_(const QString &, const QString &, const qtrapids::ParamsMap_t &, bool);

	session_t btSession_;
	AlertWaiterThread *alertWaiter_;
	torrents_t torrents_;
	std::auto_ptr<ServerSettings> settings_;
	std::auto_ptr<ServerDb> db_;
};

} // namespace qtrapids

#endif // _TEST_HPP_
