/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SEARCHPLUGIN_H
#define SEARCHPLUGIN_H

#include <vector>
#include <QObject>

#include "PluginInterface.h"

class QWidget;
class QComboBox;
class QPushButton;
class QLineEdit;
class QWebView;
class QNetworkReply;
class DownloadManager;
class QDir;

namespace qtrapids
{

class SearchPlugin : public PluginInterface
{
	Q_OBJECT
	Q_INTERFACES(qtrapids::PluginInterface)

	public:
		SearchPlugin();
		
		/// @brief Initializes the SearchPlugin
		/// @param info info.directory is used to search for searchengine description files. 
		virtual void initialize(PluginHostInterface* host, Info info);
		virtual QString identifier();
		virtual QWidget* getGui();

	signals:
		void searchResult(QWidget* resultwidget);

	private slots:
		void on_searchButton_clicked();
		void on_searchResult(QWidget* resultWidget);
		void on_loadFinished(bool ok);
		void on_networkReplyFinished(QNetworkReply* reply);
		void on_linkClicked(const QUrl& url);
		void on_downloadFinished(QString filepath);
		
	private:
		void ParseSearchEngineDescriptions(const QDir& dir);
			
	private:
		QComboBox *comboBox_; // Holds the search engine names. Combobox index maps to engineTemplates_ index
		QLineEdit *searchLine_;
		QPushButton *searchButton_;
		QWebView *result_; // Do not delete, plugin host takes ownership
		DownloadManager *dlManager_;
		PluginHostInterface* host_;
		std::vector<QString> engineTemplates_; // Holds the search URL templates
};

} // namespace qtrapids

#endif