#ifndef _QTRAPIDS_ERROR_HPP_
#define _QTRAPIDS_ERROR_HPP_

#include <QString>

namespace qtrapids
{

class Error
{
public:

	Error()
			: msg_("") { }

	Error(char const *msg)
			: msg_(msg) {}

	template <typename T>
	void append_to_msg(T val) {
		msg_ << val;
	}

private:
	QString msg_;

};

template <typename T>
Error& operator << (Error &self, T val)
{
	self.append_to_msg(val);
	return self;
}

class InvalidArgument : public Error
{
};

template <typename T>
InvalidArgument& operator << (InvalidArgument &self, T val)
{
	self.append_to_msg(val);
	return self;
}

}

#endif // _QTRAPIDS_ERROR_HPP_

