/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>
#include <QDir>
#include <QStringList>

#include "PluginInterface.h"
#include "QBittorrentSession.h"

class QTabWidget;
class DownloadView;
class SeedView;
class PreferencesDialog;
class PluginInterface; 

/**
	@author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class MainWindow : public QMainWindow, public qtrapids::PluginHostInterface
{
	Q_OBJECT

	public:
    MainWindow();
    virtual ~MainWindow();
		
		// Implemented from PluginHostInterface
		virtual bool setGui(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE, qtrapids::PluginInterface* plugin = NULL);
		virtual void addPluginWidget(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
		virtual void addToolbar(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
		virtual void addToolItem(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
		virtual void addMenu(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
		virtual void addMenuItem(QWidget* widget, PluginWidgetType type = UNKNOWN_TYPE);
		virtual bool eventRequest(QVariant param, PluginRequest req = UNKNOWN_REQUEST);
		
	signals:
		void itemSelected(bool enabled);
		
	public slots:
	private slots:
		void on_openAction_clicked();
		void on_removeAction_clicked();
		void on_quitAction_clicked();
		void on_preferencesAction_clicked();
		void on_aboutAction_clicked();
		void on_aboutQtAction_clicked();
		void on_tabWidget_tabCloseRequested(int index);
		void on_downloadItemSelectionChanged();
		void on_seedItemSelectionChanged();
		void handleToolBarAction(QAction* action);
		void on_torrentFileSelected(const QString& file);
		void on_alert(std::auto_ptr<Alert> al);
	
	private:
		void LoadPlugins();
		void RestoreSettings();
		void StartTorrentFromBufferData(char const* data, int size);
		
	private:
		QTabWidget *tabWidget_;
		DownloadView *dlView_;
		SeedView *seedView_;
		QWidget *searchWidget_;
		PreferencesDialog *preferencesDialog_;
		QSettings settings_;
		QList<QDir> pluginDirs_;
		QStringList pluginFileNames_;
		//std::vector< std::auto_ptr<QTorrentHandle> const > torrentHandles_;
		
		qtrapids::QBittorrentSession btSession_;
		

		//bool IsNewTorrent(std::auto_ptr<QTorrentHandle> handlePtr);
};

#endif
