/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DOWNLOADVIEW_H
#define DOWNLOADVIEW_H

#include <map>

#include <QTreeWidget>

#include "QBittorrentSession.h"

class DownloadViewItem;
class QTimer;

/**
	@class DownloadView
	@brief A view showing all downloaded torrents
	@author Lassi Väätämöinen <lassi.vaatamoinen@ixonos.com>
*/
class DownloadView : public QTreeWidget
{
	Q_OBJECT

public:
	DownloadView(QWidget* parent);

	~DownloadView();

	void newItem(qtrapids::QTorrentHandle handle);
	void updateItem(qtrapids::QTorrentHandle handle);
	qtrapids::QTorrentHandle removeSelected();
	void removeItem(qtrapids::QTorrentHandle handle);
	void setRefreshInterval(int msec);

private slots:
	void on_itemClicked(QTreeWidgetItem * item, int column);
	void on_timeout();

private:
	// Maps torrent to downloadview item.
	// Key: SHA1 info hash of torrent. Data: View item corresponding to torrent.
	std::map<qtrapids::QTorrentHandle, DownloadViewItem*> items_;
	QTimer *timer_;

	// Private functions.
	QString GetStatusString(qtrapids::QTorrentHandle::State const& status) const;
	QColor GetStatusColor(qtrapids::QTorrentHandle::State const& status) const;
	void UpdateView();


};


/**
	@class DownloadViewItem
	@brief Represents one item row of DownloadView
*/
class DownloadViewItem : public QTreeWidgetItem
{

public:
	DownloadViewItem(QTreeWidget* parent, int type) :
			QTreeWidgetItem(parent, type = QTreeWidgetItem::UserType) {};

	DownloadViewItem(const QStringList& strings,
	                 int type = QTreeWidgetItem::UserType) :
			QTreeWidgetItem (strings, type = Type) {};


	/// @return An item comprising of string list, suitable for QTableView
	/// header.
	static DownloadViewItem *getHeaderItem() {
		DownloadViewItem *item
		= new DownloadViewItem(QStringList()
		                       << "Name"
		                       << "Size" << "Status"
		                       << "Progress" << "DL speed"
		                       << "UL speed" << "Seeds/Leechers"
		                       << "Ratio" << "ETA");

		return item;
	}

	/// @todo QTorrentHandle as one hidden column
};

#endif
