/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "SeedView.h"

#include <QDebug>

namespace qtrapids
{

SeedView::SeedView(QWidget* parent):
		QTreeWidget(parent)
{
	setRootIsDecorated(false); // Hide branch lines, making one-level treeview (similar to list)
	setHeaderItem(SeedViewItem::getHeaderItem());

	connect(this, SIGNAL(itemPressed(QTreeWidgetItem*, int)),
	        this, SLOT(on_itemPressed(QTreeWidgetItem*, int)));
}


SeedView::~SeedView()
{
}

void SeedView::on_itemPressed(QTreeWidgetItem * item, int column)
{
	qDebug() << "SeedView::on_itemPressed() " << item << "," << column;
}

} // namespace qtrapids
