/***************************************************************************
 *   Copyright (C) 2010 by Ixonos Plc   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QDebug>
#include <QBoxLayout>
#include <QLineEdit>
#include <QLabel>
#include <QPushButton>
#include <QSpinBox>
#include <QDialogButtonBox>
#include <QAbstractButton>
#include <QFileDialog>

#include "qtrapids/dbus.hpp"
#include "proxy.h"
#include "PreferencesDialog.h"



PreferencesDialog::PreferencesDialog(QWidget* parent, Qt::WindowFlags f, QtRapidsServer *server) :
		QDialog(parent, f), // Superclass
		dirLineEdit_(NULL),
		dialogButtons_(NULL),
		uploadRateSpinBox_(NULL),
		downloadRateSpinBox_(NULL),
		server_(server),
		settings_()
{
	setWindowTitle("Preferences");

	QBoxLayout *verticalBox = new QBoxLayout(QBoxLayout::TopToBottom);
	//QBoxLayout *horizontalBox1 = new QBoxLayout(QBoxLayout::LeftToRight);
	QGridLayout *grid = new QGridLayout;
	setLayout(verticalBox);
	verticalBox->addLayout(grid);

	QLabel *dirLabel = new QLabel(tr("Download directory: "));
	dirLineEdit_ = new QLineEdit(this);
	QPushButton *browseDirButton = new QPushButton(tr("Browse.."));
	
	QLabel *uploadLabel = new QLabel(tr("Max. upload rate: "));
	QLabel *downloadLabel = new QLabel(tr("Max. download rate: "));
	uploadRateSpinBox_ = new QSpinBox(this);
	downloadRateSpinBox_ = new QSpinBox(this);
	
	grid->addWidget(dirLabel, 0, 0);
	grid->addWidget(dirLineEdit_, 0, 1);
	grid->addWidget(browseDirButton, 0, 2);
	
	grid->addWidget(uploadLabel, 1, 0);
	grid->addWidget(uploadRateSpinBox_, 1, 1);
	grid->addWidget(downloadLabel, 2, 0);
	grid->addWidget(downloadRateSpinBox_, 2, 1);
	
	uploadRateSpinBox_->setRange(0, 1000);
	uploadRateSpinBox_->setSuffix(" kB/s");
	downloadRateSpinBox_->setRange(0, 1000);
	downloadRateSpinBox_->setSuffix(" kB/s");
	
//  	horizontalBox1->addWidget(dirLabel);
//  	horizontalBox1->addWidget(dirLineEdit_);
//  	horizontalBox1->addWidget(browseDirButton);

	connect(browseDirButton, SIGNAL(clicked()),
	        this, SLOT(on_browseDirButtonClicked()));


	dialogButtons_ = new QDialogButtonBox(this);
	dialogButtons_->setStandardButtons(QDialogButtonBox::Ok
	                                   | QDialogButtonBox::Apply
	                                   | QDialogButtonBox::Cancel);

	verticalBox->addWidget(dialogButtons_);

	connect(dialogButtons_, SIGNAL(clicked(QAbstractButton*)),
	        this, SLOT(on_buttonClicked(QAbstractButton*)));

	// Set saved preference values to fields.
	ReadSettings();

}


PreferencesDialog::~PreferencesDialog()
{
}

// ======================== SLOTS ========================
void PreferencesDialog::on_browseDirButtonClicked()
{
	QString dir = QFileDialog::getExistingDirectory(this, tr("Download directory"), QString(), QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);
	on_downloadDirectorySelected(dir);
	
	/*
	QFileDialog *dialog
	= new QFileDialog(this, "Download directory",
	                  QString(), tr("Torrent files (*.torrent)"));

	dialog->setFileMode(QFileDialog::Directory);
	dialog->setOption(QFileDialog::ShowDirsOnly, true);

	connect(dialog, SIGNAL(fileSelected(const QString&)),
	        this, SLOT(on_downloadDirectorySelected(const QString&)));

	dialog->show();
	*/
}

void PreferencesDialog::on_buttonClicked(QAbstractButton* button)
{
	switch (dialogButtons_->buttonRole ( button ) ) {
	case QDialogButtonBox::AcceptRole :
		qDebug() << "PreferencesDialog: OK";
		WriteSettings();
		done(QDialog::Accepted);
		break;
	case QDialogButtonBox::ApplyRole :
		qDebug() << "PreferencesDialog: APPLY";
		WriteSettings();
		break;
	case QDialogButtonBox::RejectRole :
		qDebug() << "PreferencesDialog: CANCEL";
		done(QDialog::Rejected);
		break;
	default:
		return;
	}
}

void PreferencesDialog::on_downloadDirectorySelected(QString directory)
{
	qDebug() << "PreferencesDialog::on_downloadDirectorySelected(): " << directory;
	// Torrent filename empty, do nothing.
	if (directory == "")
		return;

	dirLineEdit_->clear();
	dirLineEdit_->insert(directory);

	/// @todo check that user has privileges to write to this directory.
}


// ========================= Private functions ==========================
void PreferencesDialog::WriteSettings()
{
	int ulRate = 1000*uploadRateSpinBox_->value();
	int dlRate = 1000*downloadRateSpinBox_->value();
	
	settings_.setValue("download/directory", dirLineEdit_->text());
	//settings_.setValue("net/uploadRate", ulRate);
	//settings_.setValue("net/downloadRate", dlRate);
	
	// NOTE: We might need to call QSettigns::sync() here to instantly write settings.
	// settings are written also by QSettings() destructor and by event loop at regular interval.
	
	// If server pointer was given, apply settings immediately.
	if (server_) {
		/// @todo Use DBus interface
		/// @todo Set parameters for server
		/// @todo Add speedlimit functionality to Server.
		qtrapids::ParamsMap_t options;
		options["net/downloadRate"] = QString::number(dlRate);
		options["net/uploadRate"] = QString::number(ulRate);
		server_->setOptions(options);
// 		btSession_->setUploadRateLimit(ulRate);
// 		btSession_->setDownloadRateLimit(dlRate);
	}
	
}

void PreferencesDialog::ReadSettings()
{
	dirLineEdit_->insert(settings_.value("download/directory").toString());
	uploadRateSpinBox_->setValue(settings_.value("net/uploadRate").toInt()/1000);
	downloadRateSpinBox_->setValue(settings_.value("net/downloadRate").toInt()/1000);
	
	// NOTE: We might need to call QSettigns::sync() here to instantly write settings.
	// settings are written also by QSettings() destructor and by event loop at regular interval.
}

