#ifndef PLUGIN_H
#define PLUGIN_H

#include <QtCore/QObject>
#include <QtGui/QMainWindow>
#include <QtCore/QString>
#include <QtGui/QIcon>
#include <QtCore/QTranslator>
#include <QtCore/QProcess>
#include "../../qtMobileHotspot/src/dbushelper.h"
#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "../../qtMobileHotspot/src/mobilehotspotplugin.h"
#include "../../qtMobileHotspot/src/mobilehotspotconfiguration.h"
#include "plugingui.h"
#include "pluginconfiguration.h"

#define TIME_PING_START_FIRST ((int)15000)
#define TIME_PING_STOP ((int)15000)
#define TIME_PING_START_RUNNING ((int)10000)
#define TIME_PING_WAIT_STOP ((int)1500)
#define TIME_WLANCHECK ((int)10000)


class Plugin : public QObject, public MobileHotspotPlugin{

	Q_OBJECT
	Q_INTERFACES(MobileHotspotPlugin)

public:
	Plugin();
	~Plugin();

	QString displayedName();
	QString displayedAuthor();
	QString displayedContact();
	QString displayedDescription();
	QIcon displayedIcon();

	QString name();
	int order();
	bool allowConfigureStopped();
	bool allowConfigureRunning();
	bool allowEnableDisableStopped();
	bool allowEnableDisableRunning();

	bool isPluginEnabled();
	void setPluginEnabled(bool enabled, const MobileHotspotConfiguration *configuration, bool running);

	void configure(const QMainWindow *parentWindow, const MobileHotspotConfiguration *configuration, bool running, bool reset);
	void beforeStarting(const MobileHotspotConfiguration *configuration);
	void afterStarting(const MobileHotspotConfiguration *configuration, bool successStarting);
	void beforeStopping(const MobileHotspotConfiguration *configuration, bool successStarting);
	void afterStopping(const MobileHotspotConfiguration *configuration, bool successStarting, bool successFinishing);

	QTranslator *translator();

private:
	MobileHotspotPluginHelper *helper; // Helper for this plugin
	PluginConfiguration *conf; // Configuration of this plugin
	QTranslator translater; // Translator of this plugin (even if there are no translations)
	PluginGUI *gui; // Configuration GUI
	const MobileHotspotConfiguration *configuration; // Qt Mobile Hotspot configuration
	bool running; // Is the hotspot running ?
	bool successStarting; // Was hotspot startup successful ?
	bool successFinishing; // Was hotspot shutdown successful ?

	Enforcement2G3G previousEnforcement;
	int previousPowerSave;
	QProcess *internetPingProcess;
	bool timedOperationsEnabled;

	int setPowerManagement(QString interface, bool management);

private slots:
	void configureFinished(); // Callback at GUI closing

	void mustStopPing();
	void mustStartPing();
	void mustCheckWLAN();
};


#endif // PLUGIN_H
