#include <QtCore/QObject>
#include <QtGui/QMessageBox>
#include <QtCore/qplugin.h>
#include <QtCore/QString>
#include <QtCore/QTranslator>
#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "../../qtMobileHotspot/src/mobilehotspotplugin.h"
#include "../../qtMobileHotspot/src/mobilehotspotconfiguration.h"
#include "pluginconfiguration.h"
#include "privoxyhelper.h"
#include "plugingui.h"
#include "plugin.h"


Plugin::Plugin(){
	helper = new MobileHotspotPluginHelper(this); // create the helper for this plugin
	conf = new PluginConfiguration(helper); // create the configuration of this plugin
	conf->load(); // load plugin's configuration (see PluginConfiguration::load())
}

Plugin::~Plugin(){
	delete conf; // delete this plugin's configuration
	delete helper; // delete this plugin's helper
	delete translater; // delete this plugin's translator (even if there is no translation)
}

QString Plugin::name(){
	return "org.dest.qtmh.privoxy"; // unique name of the plugin, wont be displayed
}

QString Plugin::displayedName(){
	return tr("Privoxy"); // displayed name in the application menu (if applyable)
}

bool Plugin::displayNameStopped(){
	return true; // get (or not) an entry in the application menu while hotspot is stopped
}

bool Plugin::displayNameRunning(){
	return false; // get (or not) an entry in the application menu while hotspot is active
}

int Plugin::order(){
	// Plugins call ordering
	// Range should be 0..100 (included)
	// Startup calls are done in natural order (0, 1, ..., 100)
	// Shutdown calls are done in reverse order (100, 99, ..., 0)
	// Ranges 0..20 and 80..100 (included) should be reserved to 'official' plugins.
	return 10; // should be run after macfilter (5) but before everything else
}

void Plugin::configure(const MobileHotspotConfiguration &configuration, const bool running){
	// Plugin's entry in the application menu has been clicked
	PluginGUI gui; // create the GUI
	gui.setConfiguration(*conf); // load plugin configuration into the GUI
	if(gui.exec() != gui.Accepted) // display the GUI
		return;
	gui.configuration(conf); // get plugin configuration from the GUI
	conf->save(); // save plugin's configuration (see PluginConfiguration::save())
}

void Plugin::beforeStarting(const MobileHotspotConfiguration &configuration){
	// Run before the startup of the hotspot

}

void Plugin::afterStarting(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run after the startup of the hotspot
	if( (! successStarting) || (! configuration.internetEnabled) || (! conf->enabled))
		return;
	int ret;

	qDebug("*** PRIVOXY STARTUP PROCESS ***");
	try{
		/** Generate configuration file from our sample **/
		ret = PrivoxyHelper::generateConfigurationFile(configuration, conf);
		if(ret != 0)
			throw QString(tr("Error while generating configuration file for privoxy"));

		/** Generate action file from our sample **/
		ret = PrivoxyHelper::generateActionFile(configuration, conf);
		if(ret != 0)
			throw QString(tr("Error while generating action file for privoxy"));

		/** Run privoxy **/
		privoxyProcess = new QProcess();
		ret = PrivoxyHelper::runPrivoxy(configuration, conf, privoxyProcess);
		if(ret != 0)
			throw QString(tr("Error while starting privoxy"));

		/** Set iptables **/
		ret = PrivoxyHelper::setIptables(configuration, conf);
		if(ret != 0)
			throw QString(tr("Error while setting iptables for privoxy"));
	}
	catch(QString fail){
		QMessageBox::warning(0, tr("Error"), fail);
	}
}

void Plugin::beforeStopping(const MobileHotspotConfiguration &configuration, const bool successStarting){
	// Run before the shutdown of the hotspot

}

void Plugin::afterStopping(const MobileHotspotConfiguration & configuration, const bool successStarting, const bool successFinishing){
	// Run after the shutdown of the hotspot
	if( (! successStarting) || (! configuration.internetEnabled) || (! conf->enabled))
		return;
	int ret;
	qDebug("*** PRIVOXY SHUTDOWN PROCESS ***");

	/** Stop privoxy **/
	ret = PrivoxyHelper::stopPrivoxy(configuration, conf, privoxyProcess);
	if(ret != 0)
		qDebug("FAILURE : Error while stopping privoxy");
	delete privoxyProcess;

	/** Delete action file **/
	ret = PrivoxyHelper::deleteActionFile(configuration, conf);
	if(ret != 0)
		qDebug("FAILURE : Error while deleting privoxy action file");

	/** Delete configuration file **/
	ret = PrivoxyHelper::deleteConfigurationFile(configuration, conf);
	if(ret != 0)
		qDebug("FAILURE : Error while deleting privoxy configuration file");
}

QTranslator* Plugin::translator(){
	// Translations need
	// Should be kept as is, even if there are no translations
	return translater;
}

void Plugin::setTranslator(QTranslator *translater){
	// Translations need
	// Should be kept as is, even if there are no translations
	this->translater = translater;
}


Q_EXPORT_PLUGIN2(qtmhprivoxy, Plugin); // 1st is target name, 2nd is class name
