#ifndef PLUGIN_H
#define PLUGIN_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QTranslator>
#include <QtCore/QProcess>
#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "../../qtMobileHotspot/src/mobilehotspotplugin.h"
#include "../../qtMobileHotspot/src/mobilehotspotconfiguration.h"
#include "pluginconfiguration.h"

#define TIME_PING_START_FIRST ((int)15000)
#define TIME_PING_STOP ((int)10000)
#define TIME_PING_START_RUNNING ((int)10000)
#define TIME_PING_WAIT_STOP ((int)1500)
#define TIME_WLANCHECK ((int)10000)
#define TIME_WLANPOWER ((int)10000)


class Plugin : public QObject, public MobileHotspotPlugin{

	Q_OBJECT
	Q_INTERFACES(MobileHotspotPlugin)

public:
	Plugin();
	~Plugin();
	QString name();
	QString displayedName();
	bool displayNameStopped();
	bool displayNameRunning();
	int order();

	void configure(const MobileHotspotConfiguration &configuration, const bool running);
	void beforeStarting(const MobileHotspotConfiguration &configuration);
	void afterStarting(const MobileHotspotConfiguration &configuration, const bool successStarting);
	void beforeStopping(const MobileHotspotConfiguration &configuration, const bool successStarting);
	void afterStopping(const MobileHotspotConfiguration &configuration, const bool successStarting, const bool successFinishing);

	void setTranslator(QTranslator *translater);
	QTranslator *translator();

private:
	MobileHotspotPluginHelper *helper; // Helper for this plugin
	PluginConfiguration *conf; // Configuration of this plugin
	QTranslator *translater; // Translator of this plugin (even if there are no translations)
	QProcess *internetPingProcess;
	bool timedOperationsEnabled;
	QString hotspotName;

	int setPowerManagement(QString interface, bool management);

private slots:
	void mustStopPing();
	void mustStartPing();
	void mustCheckWLAN();
	void mustPowerWLAN();
};


#endif // PLUGIN_H
