#include "../../qtMobileHotspot/src/mobilehotspotpluginhelper.h"
#include "pluginconfiguration.h"


PluginConfiguration::PluginConfiguration(MobileHotspotPluginHelper *helper){
	this->helper = helper; // register our helper, it is useful for loading/saving and such
}

PluginConfiguration::~PluginConfiguration(){
	// helper deletion is handled by plugin itself, no need to destroy it here
}

void PluginConfiguration::load(){
	// Load the plugin's configuration, please use the helper function load("settingName", "defaultValue")
	// some_variable = helper->load("settingName", "default value").toString();
	disablePowerSaving = helper->load("disablePowerSaving", "false").toString() == "true";
	internetPing = helper->load("internetPing", "false").toString() == "true";
	internetPingIP = helper->load("internetPingIP", "example.com").toString();
}

void PluginConfiguration::save(){
	// Save the plugin's configuration, please use the helper function save("settingName", value)
	// helper->save("settingName", some_variable);
	helper->save("disablePowerSaving", disablePowerSaving ? "true" : "false");
	helper->save("internetPing", internetPing ? "true" : "false");
	helper->save("internetPingIP", internetPingIP);
}
