#include <QtCore/QString>
#include <QtCore/QList>
#include <QtCore/QStringList>
#include <QtGui/QDialog>
#include <QtGui/QMessageBox>
#include "mobilehotspotconfiguration.h"
#include "apnhelper.h"
#include "internetaccessgui.h"


InternetAccessGUI::InternetAccessGUI(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	ui.lst2G3G->addItem(tr("No change"), "ignore");
	ui.lst2G3G->addItem(tr("2G only"), "2g");
	ui.lst2G3G->addItem(tr("3G only"), "3g");
	ui.lst2G3G->addItem(tr("2G/3G"), "2g3g");
}

InternetAccessGUI::~InternetAccessGUI()
{

}

void InternetAccessGUI::setConfiguration(MobileHotspotConfiguration &configuration){
	int configIndex = 0;
	QList<QStringList> apns = APNHelper::apnList(configuration.lanInterface == configuration.INTERFACE_WLAN);
	for(int i = 0; i < apns.size(); i++){
		ui.lstAPN->addItem( (apns.at(i).at(0) + "     ") + apns.at(i).at(2), apns.at(i).at(1));
		if(configuration.internetAPID == apns.at(i).at(1) && configuration.internetAPType == apns.at(i).at(2))
			configIndex = i;
	}
	if(configuration.enforcement2g3g == ENFORCEMENT_2G3G_IGNORE)
		ui.lst2G3G->setCurrentIndex(0);
	else if(configuration.enforcement2g3g == ENFORCEMENT_2G3G_2G)
		ui.lst2G3G->setCurrentIndex(1);
	else if(configuration.enforcement2g3g == ENFORCEMENT_2G3G_3G)
		ui.lst2G3G->setCurrentIndex(2);
	else
		ui.lst2G3G->setCurrentIndex(3);
	ui.lstAPN->setCurrentIndex(configIndex);
	ui.txtNetwork->setText(configuration.lanNetwork + "0");
	ui.chkInternet->setChecked(configuration.internetEnabled);
}

void InternetAccessGUI::configuration(MobileHotspotConfiguration *configuration){
	if(ui.lstAPN->count() > 0){
		configuration->internetAPName = ui.lstAPN->itemText(ui.lstAPN->currentIndex()).split("     ").at(0);
		configuration->internetAPType = ui.lstAPN->itemText(ui.lstAPN->currentIndex()).split("     ").at(1);
		configuration->internetAPID = ui.lstAPN->itemData(ui.lstAPN->currentIndex()).toString();
	}
	configuration->lanNetwork = validNetwork();
	configuration->internetEnabled = ui.chkInternet->isChecked();
	if(ui.lst2G3G->currentIndex() == 0)
		configuration->enforcement2g3g = ENFORCEMENT_2G3G_IGNORE;
	else if(ui.lst2G3G->currentIndex() == 1)
		configuration->enforcement2g3g = ENFORCEMENT_2G3G_2G;
	else if(ui.lst2G3G->currentIndex() == 2)
		configuration->enforcement2g3g = ENFORCEMENT_2G3G_3G;
	else
		configuration->enforcement2g3g = ENFORCEMENT_2G3G_DOUBLE;
}

QString InternetAccessGUI::validNetwork(){
	QStringList list = ui.txtNetwork->text().split('.');
	QString res;
	try{
		if(list.size() != 4)
			throw QString("fail");
		for(int i = 0; i < 3; i++){
			bool ok;
			int n = list.at(i).toInt(&ok);
			ok = ok && n >= 0 && n <= 255;
			if(! ok)
				throw QString("fail");
			res += QString::number(n) + ".";
		}
	}
	catch(QString fail){
		QMessageBox::warning(this, tr("Invalid network"), tr("The entered network is invalid. The default value will be used."));
		res = "10.40.160.";
	}
	return res;
}
