# Include global settings stored in /workspace/qtmobilehotspot/globalsettings.pri
include(../globalsettings.pri)

# Name and version of the qtMobileHotspot executable
TARGET = qtmobilehotspot
VERSION = 0.3.2

# This is a program written in QT
CONFIG += qt
TEMPLATE = app

# We need to enable DBUS
QT += dbus

# We need those lines to enable GCONF support
CONFIG += link_pkgconfig
PKGCONFIG += gq-gconf

# Destination folder
# Project organisation : /workspace/qtmobilehotspot/qtMobileHotspot[/src/source_files...]
# Executable should be in /workspace/qtmobilehotspot/build, so ../build is good
DESTDIR = ../build

# Build folders
# .o files will go in /workspace/qtmobilehotspot/qtMobileHotspot/build
# moc files will go in /workspace/qtmobilehotspot/qtMobileHotspot/src/.tmp
# ui headers will go in /workspace/qtmobilehotspot/qtMobileHotspot/src (same folder as ui cpp/h)
OBJECTS_DIR = build
MOC_DIR = src/.tmp
UI_DIR  = src

# Headers (.h)
# src = the src folder of the program
HEADERS     = src/mobilehotspotgui.h	src/ui_mobilehotspotgui.h
HEADERS    += src/accesspointgui.h	src/ui_accesspointgui.h
HEADERS	   += src/internetaccessgui.h	src/ui_internetaccessgui.h
HEADERS    += src/mobilehotspotconfiguration.h
HEADERS    += src/commandhelper.h	src/dbushelper.h	src/apnhelper.h	src/hotspothelper.h
HEADERS    += src/mobilehotspotplugin.h src/mobilehotspotpluginhelper.h

# Sources (.cpp)
# src = the src folder of the program
SOURCES     = src/main.cpp	
SOURCES    += src/mobilehotspotgui.cpp	src/accesspointgui.cpp
SOURCES    += src/internetaccessgui.cpp
SOURCES    += src/mobilehotspotconfiguration.cpp
SOURCES    += src/commandhelper.cpp	src/dbushelper.cpp	src/apnhelper.cpp	src/hotspothelper.cpp
SOURCES    += src/mobilehotspotpluginhelper.cpp

# Forms (.ui)
# src = the src folder of the program
FORMS       = src/mobilehotspotgui.ui	src/accesspointgui.ui
FORMS      += src/internetaccessgui.ui

# Translations (.ts)
# Will be generated by lupdate
TRANSLATIONS = fr.ts

# In Eclipse, "clean" removes binaries too
# This is also needed to work around timestamp issues between host and VM in ESbox
# Should not be changed, should work for any DESTDIR and TARGET
QMAKE_CLEAN += $$DESTDIR/$$TARGET

# Maemo part (http://wiki.maemo.org/Packaging_a_Qt_application#Creating_a_Maemo_package_from_a_qmake_project)
# Good helpers : source of QCpuFreq and qt-maemo-example
unix {
	#VARIABLES
	isEmpty(PREFIX) {
		PREFIX = /usr
	}
	BINDIR = /opt/qtmobilehotspot
	DATADIR =$$PREFIX/share

	DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

	#MAKE INSTALL

	INSTALLS += target lang util docs desktop icon48 icon64
	target.path =$$BINDIR
	
	lang.path = $$BINDIR/lang
	lang.files += data/lang/*

	util.path = $$BINDIR/util
	util.files += data/util/*
	
	docs.path = $$BINDIR/docs
	docs.files += data/docs/*

	desktop.path = /usr/share/applications/hildon
	desktop.files += data/qtmobilehotspot.desktop

	icon48.path = $$DATADIR/icons/hicolor/48x48/hildon
	icon48.files += data/48x48/qtmobilehotspot.png

	icon64.path = $$DATADIR/icons/hicolor/64x64/hildon
	icon64.files += data/64x64/qtmobilehotspot.png

}
