#ifndef MOBILEHOTSPOTCONFIGURATION_H
#define MOBILEHOTSPOTCONFIGURATION_H

#include <QtCore/QMap>
#include <QtCore/QObject>
#include <QtCore/QString>


#define GCONF "/apps/qtmobilehotspot"
#define GCONF_APNAME GCONF "/name"
#define GCONF_ENCRYPTION GCONF "/encryption"
#define GCONF_KEY GCONF "/key"
#define GCONF_INTERFACE GCONF "/interface"
#define GCONF_APN GCONF "/apn"
#define GCONF_APID GCONF "/apid"
#define GCONF_NETWORK GCONF "/network"
#define GCONF_INTERNET GCONF "/internet"
#define GCONF_2G3G	GCONF "/2g3g"


enum Enforcement{
	ENFORCE_2G,
	ENFORCE_3G,
	ENFORCE_2G3G,
	IGNORE
};


class MobileHotspotConfiguration : public QObject
{
    Q_OBJECT

public:
	static const QString ENCRYPTION_NONE;
	static const QString ENCRYPTION_WEP;
	static const QString INTERFACE_WLAN;
	static const QString INTERFACE_USB;

	QString apname, encryption, key, interface, network, apn, apid;
	bool internet;
	Enforcement enforcement2g3g;

public:
	MobileHotspotConfiguration(QObject *parent = 0);
    ~MobileHotspotConfiguration();
    void load();
    void save();
};

#endif // MOBILEHOTSPOTCONFIGURATION_H
