/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef SCROLLBAR_H
#define SCROLLBAR_H

#include <QObject>
#include <QString>
#include <QTimer>
#include <QGraphicsPixmapItem>
#include <QPropertyAnimation>
#include <QAbstractAnimation>

class ScrollBar: public QObject, public QGraphicsPixmapItem
{
    Q_OBJECT
public:
    ScrollBar(QGraphicsItem* parent);
    virtual ~ScrollBar() {}

    void updateUI();

    qreal maximum();
    void setMaximum(qreal max);

    qreal value();
    void setValue(qreal);

    Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity);

public slots:
    void updatePosition(qreal);
    void setLandscapeOrientation();
    void setPortraitOrientation();

private slots:
    void animationFinished();
    void timeout();

private:
    QPropertyAnimation* propertyAnimation(const char* name);
    QAbstractAnimation* showAnimation();
    QAbstractAnimation* hideAnimation();

    void startTimer();

    enum State {
        Hidden,
        ShowAnimation,
        Visible,
        HideAnimation
    };
    State m_state;

    qreal m_maximum;
    qreal m_value;
    QTimer m_timer;
    QAbstractAnimation* m_animation;
    QGraphicsPixmapItem m_knob;
};

#endif /* SCROLLBAR_H */
