/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui>
#include <QDebug>

#include "system.h"
#include "maincontainer.h"
#include "designinformation.h"
#include "shoppinglistcategoryui.h"
#include "shoppinglistview.h"


static ShoppingListCategoryUI *createList(const QString &category, int itemCount)
{
    ShoppingListCategoryUI *result = new ShoppingListCategoryUI(category);
    QString textsKey = "category.string_list." + category;
    QStringList texts = DesignInformation::getStringList(textsKey);

    QList<ContentListItem*> items;

    for (int i = 0; i < itemCount && i < texts.count(); ++i) {
        ShoppingListItem *item = new ShoppingListItem(QString::number(i + 1) + " - " + texts[i],
                                                      result->list(), i);
        items.append(item);
    }
    result->list()->appendItems(items);

    return result;
}

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    MainContainer* lists = new MainContainer();

    QGraphicsScene scene;
    ShoppingListView view(lists);
    view.setScene(&scene);


    QObject::connect(QApplication::desktop(), SIGNAL(resized(int)), &view, SLOT(resized(int)));

    view.adjustScalingFactor();
    view.adjustScreenSize();

    lists->add(createList("groceries", 60));
    lists->add(createList("beverages", 20));
    lists->add(createList("cleaning", 60));
    lists->add(createList("garden", 80));
    lists->add(createList("pet", 100));
    lists->add(createList("toiletries", 200));

    scene.addItem(lists);

    System::setViewMode(&view, System::PortraitMode);

#if defined(Q_OS_SYMBIAN) || defined(Q_WS_MAEMO_5)
    view.showFullScreen();
#else
    view.show();
#endif

    return app.exec();
}
