/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef DESIGNINFORMATION_H
#define DESIGNINFORMATION_H

#include <QString>
#include <QMap>
#include <QPixmap>

class DesignInformation
{
public:
    static QPixmap getPixmap(const QString &name);
    static QPointF getPosition(const QString &name);
    static qreal getVerticalSize(const QString &name);
    static qreal getHorizontalSize(const QString &name);
    static int getFontSize(const QString name);
    static QStringList getStringList(const QString &name);
    static void setScaleFactor(QSizeF factor);
    static QSizeF getScaleFactor(QSizeF screenSize);
    static void setScreenSize(QSizeF size);
private:
    template<class T, class R = T> class ValueData
    {
    public:
        ValueData(R reference) : m_upToDate(false), m_reference(reference) {}
        bool m_upToDate;
        const R m_reference;
        T m_value;
    };
private:
    QSizeF m_scaleFactor;
    QMap<QString, ValueData<QPixmap, QString>* > m_pixmaps;
    QMap<QString, ValueData<QPointF>* > m_positions;
    QMap<QString, ValueData<qreal>* > m_verticalSizes;
    QMap<QString, ValueData<qreal>* > m_horizontalSizes;
    QMap<QString, ValueData<int>* > m_fontSizes;

    QMap<QString, const char**> m_stringLists;

    static const int m_listTop = 142;
    static const int m_referenceWidth = 480;
    static const int m_minimumVisibleItems = 3;
    static const int m_referenceItemHeight = 90;

    DesignInformation();
    ~DesignInformation();
    static inline DesignInformation *instance();
    static qreal calculateScaleFactor(QSizeF screenSize);

    template<class T, class R, class F>
    static T getValue(QMap<QString, ValueData<T,R>* > map, QString key, F factory, QSizeF scale);
    template<class T, class R>
    static void resetValues(QMap<QString, ValueData<T,R>* > map);
};

#endif // DESIGNINFORMATION_H
