/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include "listshadow.h"
#include <QPropertyAnimation>
#include "designinformation.h"

ListShadow::ListShadow(QGraphicsItem *parent)
    : QGraphicsPixmapItem(parent)
    , m_focused(false)
    , m_completed(false)
    , m_animation(0)
{
    setOpacity(getTargetOpacity());
    setVisible(opacity() != 0.0);
}

ListShadow::~ListShadow()
{
    if (m_animation)
        m_animation->deleteLater();
}

void ListShadow::setFocused(bool focused)
{
    if (focused != m_focused) {
        m_focused = focused;
        createAnimation(getTargetOpacity());
    }
}

void ListShadow::setCompleted(bool completed)
{
    if (m_completed != completed) {
        m_completed = completed;
        createAnimation(getTargetOpacity());
    }
}

qreal ListShadow::getTargetOpacity()
{
    return !m_focused ? 1.0 : m_completed ? 0.2 : 0.0;
}

void ListShadow::createAnimation(qreal target)
{
    if (m_animation)
        m_animation->deleteLater();

    QPropertyAnimation* animation = new QPropertyAnimation(this, "opacity");
    animation->setEasingCurve(QEasingCurve::OutExpo);
    animation->setEndValue(target);
    animation->setDuration(500);
    if (target == 0.0)
        connect(animation, SIGNAL(finished()), this, SLOT(doHide()));
    connect(animation, SIGNAL(finished()), this, SLOT(animationEnd()));

    m_animation = animation;
    m_animation->start(QAbstractAnimation::DeleteWhenStopped);
    show();
}
