/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QPixmap>

#include "scrollbar.h"


class ScrollBarPrivate
{
public:
    ScrollBarPrivate(ScrollBar *qptr);
    void updateKnob();

    ScrollBar *q;
    int value;
    int pageSize;
    int maximum;
    PixmapWidget *knob;
};

ScrollBarPrivate::ScrollBarPrivate(ScrollBar *qptr)
    : q(qptr), value(0), pageSize(10), maximum(100)
{

}

void ScrollBarPrivate::updateKnob()
{
    qreal th = q->size().height();
    qreal fh = ((qreal)pageSize / qMax(pageSize + maximum, 1)) * th;

    int tb, bb;
    knob->getBorders(0, &tb, 0, &bb);
    knob->resize(knob->preferredWidth(), qBound<qreal>(tb + bb, fh, th));

    qreal max = qMax<qreal>(0, th - knob->size().height());
    knob->setY((value * max) / qMax(1, maximum));
}


ScrollBar::ScrollBar(const QPixmap &background,
                     const QPixmap &foreground,
                     QGraphicsItem *parent)
    : PixmapWidget(background, parent),
      d(new ScrollBarPrivate(this))
{
    setCacheMode(QGraphicsItem::ItemCoordinateCache);
    setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding);

    d->knob = new PixmapWidget(foreground, this);
    d->knob->setCacheMode(QGraphicsItem::ItemCoordinateCache);
    d->knob->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding);

    d->knob->setPos(0, 0);
    d->updateKnob();
}

int ScrollBar::value() const
{
    return d->value;
}

void ScrollBar::setValue(int value)
{
    if (d->value != value) {
        d->value = value;
        d->updateKnob();
    }
}

int ScrollBar::maximum() const
{
    return d->maximum;
}

void ScrollBar::setMaximum(int maximum)
{
    if (d->maximum != maximum) {
        d->maximum = maximum;
        d->updateKnob();
    }
}

int ScrollBar::pageSize() const
{
    return d->pageSize;
}

void ScrollBar::setPageSize(int pageSize)
{
    if (d->pageSize != pageSize) {
        d->pageSize = pageSize;
        d->updateKnob();
    }
}

void ScrollBar::setKnobBorders(int left, int top, int right, int bottom)
{
    d->knob->setBorders(left, top, right, bottom);
}

void ScrollBar::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    PixmapWidget::resizeEvent(event);
    d->updateKnob();
}
