/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QPainter>
#include <QFontMetrics>

#include "dataresource.h"
#include "pagemenu.h"


PageMenu::PageMenu(QGraphicsItem *parent)
    : QGraphicsWidget(parent),
      m_background(Resource::pixmap("top_bar_active.png"))
{
    QFont textFont = QFont(Resource::stringValue("default/font-family"));
    textFont.setPixelSize(Resource::intValue("page-menu/font-size"));
    setFont(textFont);

    m_textRect = Resource::value("page-menu/label-rect").toRect();
    m_fontColor = QColor(Resource::stringValue("default/font-color"));

    setMinimumSize(m_background.size());
    setMaximumSize(m_background.size());
}

QString PageMenu::text() const
{
    return m_text;
}

void PageMenu::setText(const QString &text)
{
    if (m_text != text) {
        m_text = text;
        update();
    }
}

void PageMenu::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                     QWidget *widget)
{
    Q_UNUSED(option);
    Q_UNUSED(widget);

    painter->drawPixmap(0, 0, m_background);

    QFontMetrics metrics(font());
    const QString &elidedText = metrics.elidedText(m_text, Qt::ElideRight,
                                                   m_textRect.width());

    painter->setFont(font());
    painter->setPen(m_fontColor);
    painter->drawText(m_textRect, Qt::TextSingleLine | Qt::AlignCenter, elidedText);
}
