/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: openBossa - INdT (renato.chencarek@openbossa.org)
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** the openBossa stream from INdT (renato.chencarek@openbossa.org).
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QApplication>
#include <QGraphicsScene>
#include <QGraphicsView>

#include "system.h"
#include "dataresource.h"
#include "mainwindow.h"


int main(int argc, char **argv)
{
#ifdef USE_RASTER_GRAPHICS_SYSTEM
    QApplication::setGraphicsSystem("raster");
#endif

    Resource::setIniFile(":/hyperui.ini");
    Resource::setPixmapPrefix(":/images/");

    QApplication app(argc, argv);

    const int width = Resource::intValue("window/width");
    const int height = Resource::intValue("window/height");

    QGraphicsScene scene;
    QGraphicsView view(&scene);

    view.setWindowTitle(QObject::tr("Hiper UI"));
    view.setFrameShape(QFrame::NoFrame);
    view.setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view.setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view.setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);

    view.resize(width, height);
    scene.setSceneRect(0, 0, width, height);

    MainWindow mainWindow;
    scene.addItem(&mainWindow);
    mainWindow.setGeometry(0, 0, width, height);

    System::setViewMode(&view, System::PortraitMode);

#if defined(Q_OS_SYMBIAN) || defined(Q_WS_MAEMO_5)
    view.showFullScreen();
#else
    view.setFixedSize(width, height);
    view.show();
#endif

    return app.exec();
}
