/* Copyright (c) 2010, Nokia Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * * Neither the name of the Nokia Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * The D-BUS service implementation qtm-modest-plugin
 */

#ifndef QTMM_DBUS_SERVICE_H_
#define QTMM_DBUS_DERVICE_H_

#include <glib.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/* GObject type "convenience" macros */
#define QTMM_TYPE_DBUS_SERVICE            (qtmm_dbus_service_get_type())
#define QTMM_DBUS_SERVICE(obj)            (G_TYPE_CHECK_INSTANCE_CAST(  \
                                               (obj),                   \
                                               QTMM_TYPE_DBUS_SERVICE,  \
                                               QtmMDBusService))
#define QTMM_DBUS_SERVICE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(     \
                                               (klass),                 \
                                               QTMM_TYPE_DBUS_SERVICE,  \
                                               QtmMDBusServiceClass))
#define QTMM_IS_DBUS_SERVICE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE(  \
                                               (obj),                   \
                                               QTMM_TYPE_DBUS_SERVICE))
#define QTMM_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(     \
                                               (klass),                 \
                                               QTMM_TYPE_DBUS_SERVICE))
#define QTMM_DBUS_SERVICE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(   \
                                               (obj),                   \
                                               QTMM_TYPE_DBUS_SERVICE,  \
                                               QtmMDBusService))

/*
 * The actual "class" definitions
 */
typedef struct _QtmMDBusService        QtmMDBusService;
typedef struct _QtmMDBusServiceClass   QtmMDBusServiceClass;
typedef struct _QtmMDBusServicePrivate QtmMDBusServicePrivate;

struct _QtmMDBusService {
    GObject       parent;

    /*<private>*/
    QtmMDBusServicePrivate *priv;
};

struct _QtmMDBusServiceClass {
    GObjectClass  parent_class;
};

GType qtmm_dbus_service_get_type (void) G_GNUC_CONST;

/*
 * Public functions
 */

/*
 * Create a new instance
 */
GObject *
qtmm_dbus_service_new (void);

/*
 * Get email message contents
 */
gboolean
com_nokia_Qtm_Modest_Plugin_get_message (
    QtmMDBusService *self,
    const gchar *inAccountId,
    const gchar *inFolderId,
    const gchar *inMessageId,
    DBusGMethodInvocation *context);

/*
 * Send an email
 */
gboolean
com_nokia_Qtm_Modest_Plugin_send_email (
    QtmMDBusService *self,
    GHashTable      *inSenderInfo,
    GHashTable      *inRecipients,
    GHashTable      *inMessageData,
    const GPtrArray *inAttachments,
    const GPtrArray *inImages,
    guint            inPriority,
    GHashTable      *inHeaderFields,
    DBusGMethodInvocation *context);

/*
 * Fetch email headers
 */
gboolean
com_nokia_Qtm_Modest_Plugin_get_headers (
    QtmMDBusService  *self,
    const gchar     **inAccountIds,
    const gchar     **inFolders,
    guint64           inBeginTime,
    guint64           inEndTime,
    gboolean          inSync,
    DBusGMethodInvocation *context);

/*
 * Adds a message into a folder
 */
gboolean
com_nokia_Qtm_Modest_Plugin_add_message (
    QtmMDBusService *self,
    const gchar     *inFolderId,
    GHashTable      *inSenderInfo,
    GHashTable      *inRecipients,
    GHashTable      *inMessageData,
    const GPtrArray *inAttachments,
    const GPtrArray *inImages,
    guint            inPriority,
    GHashTable      *inHeaderFields,
    DBusGMethodInvocation *context);

/*
 * Fetches attachment data for reading to client, if it's available
 */
gboolean
com_nokia_Qtm_Modest_Plugin_get_mime_part (
    QtmMDBusService *self,
    const gchar *inAccountId,
    const gchar *inFolderId,
    const gchar *inMessageId,
    const gchar *inMimePartId,
    DBusGMethodInvocation *context);

/*
 * Adds a folder into an account
 */
gboolean
com_nokia_Qtm_Modest_Plugin_add_folder (
    QtmMDBusService *self,
    const gchar *inAccountId,
    const gchar *inFolderName,
    DBusGMethodInvocation *context);

/*
 * Removes folder from an account
 */
gboolean
com_nokia_Qtm_Modest_Plugin_remove_folder (
    QtmMDBusService *self,
    const gchar *inAccountId,
    const gchar *inFolderId,
    DBusGMethodInvocation *context);

G_END_DECLS

#endif /* QTMM_DBUS_SERVICE_H_ */
