//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsradiomode.h"
#include "lockscreen.h"

LsRadioMode::LsRadioMode(QString name) :
        LsImage(name.isEmpty() ? "RadioMode": name)
{
    applySettings();

    if (LockScreen::Debug){
        m_Mode = 2;
        setImage();
    }

#ifdef Q_WS_MAEMO_5
    m_Mode = 0;
#else
    m_Mode = 2;
    setImage();
#endif
}

void LsRadioMode::applySettings()
{
    m_3g = getSetting("3gIcon", "/opt/qtlockscreen/default/radio_3g.png").toString();
    m_2g = getSetting("2gIcon", "/opt/qtlockscreen/default/radio_2g.png").toString();

    setSizeAndPosition(QSize(18, 11),QPoint(0, 0));
}

void LsRadioMode::startUpdate()
{
#ifdef Q_WS_MAEMO_5
    if (!LockScreen::Debug)
        getCurrentMode();
    QDBusConnection::systemBus().connect("", "/com/nokia/phone/net", "Phone.Net",
                                         "radio_access_technology_change", this, SLOT(onRadioModeChange(QDBusMessage)));
#endif
}

void LsRadioMode::stopUpdate()
{
#ifdef Q_WS_MAEMO_5
    QDBusConnection::systemBus().disconnect("", "/com/nokia/phone/net", "Phone.Net",
                                            "radio_access_technology_change", this, SLOT(onRadioModeChange(QDBusMessage)));
#endif
}

#ifdef Q_WS_MAEMO_5
void LsRadioMode::onRadioModeChange(QDBusMessage msg)
{
    if (msg.arguments().count() > 0){
        int mode = msg.arguments()[0].toInt();
        if (mode != m_Mode){
            m_Mode = mode;
            qDebug() << "Phone radio mode changed:" << m_Mode;
            setImage();
        }
    }
}
#endif

void LsRadioMode::setImage()
{
    switch (m_Mode){
    case 1:
        m_Image = QPixmap(m_2g);
        break;
    case 2:
        m_Image = QPixmap(m_3g);
        break;
    default:
        m_Image = QPixmap();        
        break;
    }
    update();
}

void LsRadioMode::getCurrentMode()
{
#ifdef Q_WS_MAEMO_5
    QDBusInterface device(QLatin1String("com.nokia.phone.net"),
                          QLatin1String("/com/nokia/phone/net"),
                          QLatin1String("Phone.Net"),
                          QDBusConnection::systemBus());
    qDebug() << "com.nokia.phone.net::get_radio_access_technology";
    QDBusMessage msg = device.call(QLatin1String("get_radio_access_technology"));
    if (msg.type() == QDBusMessage::ErrorMessage)
        qWarning() << msg.errorMessage();
    else
        onRadioModeChange(msg);
#endif
}
