//    QtLockscreen
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "lsphonesignal.h"
#include "math.h"
#include "lockscreen.h"

LsPhoneSignal::LsPhoneSignal(QString name) :
    LsImage(name.isEmpty() ? "PhoneSignal": name)
{    
    applySettings();

    if (LockScreen::Debug){
        m_Strength = 100;
        setImage();
    }
#ifdef Q_WS_MAEMO_5
    m_Strength = 0;
#else
    m_Strength = 100;
    setImage();
#endif
}

void LsPhoneSignal::applySettings()
{
    QString images = getSetting("Images",
                                "/opt/qtlockscreen/default/signal_0.png;/opt/qtlockscreen/default/signal_1.png;/opt/qtlockscreen/default/signal_2.png;/opt/qtlockscreen/default/signal_3.png;/opt/qtlockscreen/default/signal_4.png;/opt/qtlockscreen/default/signal_5.png").toString();

    m_Images = images.split(';');
    setSizeAndPosition(QSize(44, 58),QPoint(0, 0));
}

void LsPhoneSignal::stopUpdate()
{
#ifdef Q_WS_MAEMO_5
    QDBusConnection::systemBus().disconnect("", "/com/nokia/phone/net", "Phone.Net",
                                            "signal_strength_change", this, SLOT(onSignalChange(QDBusMessage)));
#endif
}

void LsPhoneSignal::startUpdate()
{
#ifdef Q_WS_MAEMO_5
    if (!LockScreen::Debug)
        getSignalStrength();
    QDBusConnection::systemBus().connect("", "/com/nokia/phone/net", "Phone.Net",
                                         "signal_strength_change", this, SLOT(onSignalChange(QDBusMessage)));
#endif
}

#ifdef Q_WS_MAEMO_5
void LsPhoneSignal::onSignalChange(QDBusMessage msg)
{
    if (msg.arguments().count() > 0){
        int strength = msg.arguments()[0].toInt();
        if (strength != m_Strength){
            m_Strength = strength;
            qDebug() << "Phone signal strength changed:" << m_Strength;
            setImage();
        }
    }
}
#endif

void LsPhoneSignal::setImage()
{
    if (m_Images.count() > 0){
        int idx = ceil(m_Strength / (100.0 / (float)m_Images.count()) - 1.0);
        if (idx < 0)
            idx = 0;
        if (m_CurrImage != m_Images.at(idx)){
            m_CurrImage = m_Images.at(idx);
            m_Image = QPixmap(m_CurrImage);
            update();
        }
    }
}

void LsPhoneSignal::getSignalStrength()
{
#ifdef Q_WS_MAEMO_5
    QDBusInterface device(QLatin1String("com.nokia.phone.net"),
                          QLatin1String("/com/nokia/phone/net"),
                          QLatin1String("Phone.Net"),
                          QDBusConnection::systemBus());
    qDebug() << "com.nokia.phone.net::get_signal_strength";
    QDBusMessage msg = device.call(QLatin1String("get_signal_strength"));
    if (msg.type() == QDBusMessage::ErrorMessage)
        qWarning() << msg.errorMessage();
    else
        onSignalChange(msg);
#endif
}
