#ifndef SYSTEMPLAYER_H
#define SYSTEMPLAYER_H

#include <QObject>
#include <QMap>
#include <QString>
#include <QVariant>

#ifdef Q_WS_MAEMO_5
    #include "backends/mafw/mafwrendereradapter.h"
    #include "backends/mafw/mafwplaylistadapter.h"
#endif

#define SYSTEM_PLAYER_SONG_TITLE "title"
#define SYSTEM_PLAYER_SONG_ALBUM "album"
#define SYSTEM_PLAYER_SONG_ARTIST "artist"
#define SYSTEM_PLAYER_ALBUM_ART "album-art"

class SystemPlayer : public QObject
{
    Q_OBJECT
public:
    explicit SystemPlayer(QObject *parent = 0);
    enum PlaybackState {PlayingState,
                        StoppedState,
                        PausedState,
                        UnknownState};
    SystemPlayer::PlaybackState state();

signals:
    void stateChanged(SystemPlayer::PlaybackState state);
    void metadataChanged(QMap<QString,QVariant> metadata);
    void gotPosition(int, QString);

public slots:
    void play();
    void pause();
    void stop();
    void resume();
    void next();
    void previous();
    void getPosition();

private:
#ifdef Q_WS_MAEMO_5
    MafwRendererAdapter *m_renderer;
    MafwPlaylistAdapter* m_Playlist;
    int m_mafwState;
#endif
    SystemPlayer::PlaybackState m_state;
    QString m_ObjectId;

private slots:
#ifdef Q_WS_MAEMO_5
    // Internal mafw state handling
    void mafwStateChanged(int mafwState);
    void mafwMediaChanged(int index, char* objectId);
    void onGotMafwState(MafwPlaylist*, uint, MafwPlayState, const char*, QString);
    void onGotMafwMetadata(GHashTable*,QString,QString);
    void onPlaylistChanged();
    void onGotPosition(int, QString);
#endif
};

#endif // SYSTEMPLAYER_H
