#include <QApplication>
#include <QDebug>

#include "despotifywrap.h"
#include "audio.h"



static void callback(struct despotify_session* ds, int signal, void* data, void* callback_data)
{
    /* Just forward the callback to the callback handler */
    dc.ReceiveCallback(signal,data,callback_data);
}


DespotifyWrap::DespotifyWrap() {

    this->initialized = despotify_init();

    if(this->initialized){
        this->ds = despotify_init_client(callback, NULL, true);
        if(!ds) {
            this->initialized = false;
            qDebug() << "despotify_init_client failed";
        }
    } else {
        qDebug() << "despotify_init failed";
    }

    this->audio_device = audio_init();
    qDebug() << "Initializing thread...";
    this->player = new DespotifyPlay(this->ds,this->audio_device);
    qDebug() << "Starting thread...";
    this->player->start();

}

bool DespotifyWrap::Authenticate(char *user, char *pass) {

    if (!despotify_authenticate(this->ds, user, pass)) {
        qDebug() << "Authentication failed: " << (char*)despotify_get_error(ds);
        //despotify_exit(ds);
        return false;
    } else {
        /* Authentication succeeded, fetch stored playlists */
        qDebug() << "Authentication suceeded, fetching playlists";
        return true;
    }
}

bool DespotifyWrap::UpdatePlaylists() {
     /* Fetch playlists */
     qDebug() << "Updating playslists";
     playlist *current_playlist = despotify_get_stored_playlists(ds);

     this->playlists = current_playlist;
     qDebug() << "Sending signal PlaylistUpdated()";
     emit this->PlaylistsUpdated();

}

bool DespotifyWrap::IsInitialized() {
    return this->initialized;
}

playlist* DespotifyWrap::GetPlaylists() {
    return this->playlists;
}

void DespotifyWrap::Play(int list_offset) {

    track *t = this->lastlist->tracks;
    this->current_offset = list_offset;
    for (int i=0; i<list_offset && t; i++) {
        t = t->next;
        this->current_offset = i+1;
    }

    if (t&&t->playable) {

        /* Stop despotify playback */
        this->player->Pause();

        /* Start playing the new song */
        this->player->NewSong(this->ds, t, true);
    }
}

bool DespotifyWrap::Search(char *searchstring) {

     search_result* search;

     this->player->Pause();

     search = despotify_search(this->ds, searchstring, MAX_SEARCH_RESULTS);
     if (!search) {
         qDebug() << " search failed: " << despotify_get_error(this->ds);
         return false;
     } else {
         this->lastlist = search->playlist;
         return true;
     }

}

void DespotifyWrap::PlayNext() {

    track *t = this->lastlist->tracks;
    int offset = 0;
    for (int i=0; i<=current_offset && t; i++) {
        t = t->next;
        offset = i+1;
    }
    if(!t) {
        offset = 0;
    }
    this->Play(offset);

}

void DespotifyWrap::PlayPrev() {

    track *t = this->lastlist->tracks;
    int offset = 0;
    if(this->current_offset==0) {
        for (int i=0; t->next; i++) {
            t = t->next;
            offset = i+1;
        }
    } else {
        for (int i=0; i<this->current_offset && t; i++) {
            t = t->next;
            offset = i;
        }
    }

    if(!t) {
        offset = 0;
    }
    this->Play(offset);

}

void DespotifyWrap::Exit() {
    this->player->Exit();
}
