#include "settings.h"
#include "ui_settings.h"
#include <QtGui>
#include <QSqlQuery>
#include <QListWidgetItem>

bool bshowSide1;
bool bshowSide2;
bool bshowSide3;
bool bshowSide4;
int sortBy;
int selectBy;
int iChapterIDSettings;
int iCourseIDSettings;


Settings::Settings(QWidget *parent)
     : QDialog(parent)//, ui(new Ui::Settings)
{
    setupUi(this);

    scrollArea->setProperty("FingerScrollable", true);
    scrollArea->setWidgetResizable(true);
    QButtonGroup btngSelection;
    QButtonGroup btngOrder;
}

void Settings::setshowSide1(bool b)
{
    bshowSide1 = b;
}
void Settings::setshowSide2(bool b)
{
    bshowSide2 = b;
}
void Settings::setshowSide3(bool b)
{
    bshowSide3 = b;
}
void Settings::setshowSide4(bool b)
{
    bshowSide4 = b;
}

bool Settings::showSide1()
{
   return bshowSide1;
}

bool Settings::showSide2()
{
   return bshowSide2;
}
bool Settings::showSide3()
{
   return bshowSide3;
}
bool Settings::showSide4()
{
   return bshowSide4;
}

int Settings::courseID()
{
    return iCourseIDSettings;
}

int Settings::chapterID()
{
    return iChapterIDSettings;
}

int Settings::selectBy()
{

    if (btngSelection->checkedButton()->text()== "All")
    {
        return 1;
    }
    else if (btngSelection->checkedButton()->text()== "Not Learned")
    {
        return 2;
    }
    else
    {
        return 0;
    }
}

int Settings::sortBy()
{
    if (btngOrder->checkedButton()->text()== "Random")
    {
        return 1;
    }
    else if (btngOrder->checkedButton()->text()== "Alphabetic")
    {
        return 2;
    }
    else if (btngOrder->checkedButton()->text()== "Difficulty")
    {
        return 3;
    }
    else //"Not learned"
    {
        return 0;
    }
}

void Settings::on_pbOK_clicked()
{
    QSqlQuery qry;

        bshowSide1 = checkBox->isChecked();
        qDebug() << "bshowSide1" << bshowSide1;
        bshowSide2 = checkBox_2->isChecked();
        qDebug() << "bshowSide2" << bshowSide2;
        bshowSide3 = checkBox_3->isChecked();
        qDebug() << "bshowSide3" << bshowSide3;

        qry.prepare("UPDATE settings SET courseid=:courseid, chapterid=:chapterid");

        qry.bindValue(":courseid", iCourseIDSettings);
        qry.bindValue(":chapterid", iChapterIDSettings);

        qDebug() << "iCourseID=" << iCourseIDSettings;
        qDebug() << "iChapterID=" << iChapterIDSettings;

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
//            qDebug() << qry.lastError();
        }

}

void Settings::on_listChapter_activated(QString sChapterName)
{
    QSqlQuery qry;

    qry.prepare("SELECT rowid "
                "FROM chapters "
                "WHERE name=:name");

    qDebug() << "sChapterName" << sChapterName;
    qry.bindValue(":name", sChapterName);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
//        qDebug() << qry.lastError();
    }

    qry.next();
    iChapterIDSettings=qry.value(0).toInt();
    qDebug() << "iChapterIDSettings" << iChapterIDSettings;
}

//void Settings::on_lstCourse_activated(QString sCourseName)
void Settings::on_lstCourse_currentIndexChanged(QString sCourseName)
{
    QSqlQuery qry;
//    QString sCourseName;
//    int iCourseID = 1;

//    sCourseName = lstCourse->currentText();

    qry.prepare("SELECT rowid, showSide1, showSide2, showSide3, showSide4, "
                "sortBy, selectBy, "
                "side1 , side2, side3, side4 "
                "FROM courses "
                "WHERE name=:name");

    qDebug() << "sCourseName" << sCourseName;
    qry.bindValue(":name", sCourseName);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
//        qDebug() << qry.lastError();
    }

    qry.next();
    iCourseIDSettings=qry.value(0).toInt();
    qDebug() << "iCourseIDSettings" << iCourseIDSettings;
    checkBox->setChecked(qry.value(1).toBool());
    checkBox_2->setChecked(qry.value(2).toBool());
    checkBox_3->setChecked(qry.value(3).toBool());
    checkBox->setText(qry.value(7).toString());
    qDebug() << qry.value(7).toString();
    checkBox_2->setText(qry.value(8).toString());
    qDebug() << qry.value(8).toString();
    checkBox_3->setText(qry.value(9).toString());
    qDebug() << qry.value(9).toString();
//    showSide4=qry.value(4).toInt();

    switch (qry.value(5).toInt()){
    case 0:
//        break;
    case 1:
        radioButton_3->setChecked(true);
        break;
    case 2:
        radioButton_4->setChecked(true);
        break;
    case 3:
        radioButton_5->setChecked(true);
        break;
    }

    switch (qry.value(6).toInt()){
    case 0:
//        break;
    case 1:
        radioButton->setChecked(true);
        break;
    case 2:
        radioButton_2->setChecked(true);
        break;
    }

    qry.prepare("SELECT * "
                "FROM chapters "
                "WHERE courseid=:courseid");

    qDebug() << iCourseIDSettings;
    qry.bindValue(":courseid", iCourseIDSettings);
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.size();
//        qDebug() << qry.lastError();
    }

    qDebug() << qry.numRowsAffected();
    qry.next();
    listChapter->clear();
    while (qry.isValid())
    {
        qDebug() << qry.value(0);
        qDebug() << qry.value(1);
        qDebug() << qry.value(2);
        qDebug() << qry.value(3);
        listChapter->addItem(qry.value(0).toString());
        qry.next();
    }
}


//Settings::~Settings()
//{
//    delete ui;
//}

