#include "taskeditor.h"
#include "ui_taskeditor.h"
#include <QSignalMapper>
#include <QDebug>
#include <QLabel>
#include <QIcon>

#include "platutil.h"
TaskEditor::TaskEditor(TaskEntry& tent, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::TaskEditor)
{
    PlatUtil::configureWindow(this);

    ui->setupUi(this);
    connect(ui->pushButton, SIGNAL(clicked()), this, SLOT(doApply()));
    m_current = tent;
    ui->lineEdit->setText(tent.desc);
    setWindowTitle(tent.desc);
    //ui->btnCategory->setText(tent.);

    createFolderLinks(ui->frame);    
    connect(ui->actionDelete, SIGNAL(triggered()), this, SLOT(actDelete()));

}

TaskEditor::~TaskEditor()
{
    delete ui;
}

void TaskEditor::actDelete()
{
    TodoModel::instance()->deleteTask(m_current);
    deleteLater();
}

void TaskEditor::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void  TaskEditor::doApply()
{
    m_current.desc = ui->lineEdit->text();
    TodoModel::instance()->commitTask(m_current);
    deleteLater();

}

void TaskEditor::createFolderLinks(QWidget* wdg)
{
    QVBoxLayout* vb = new QVBoxLayout();

    vb->addStretch();
    QHBoxLayout* hl = new QHBoxLayout();

    QLabel* tohint = new QLabel(this);
    tohint->setText("To:");
    hl->addWidget(tohint);
    vb->addLayout(hl);
    wdg->setLayout(vb);
    QSignalMapper* mapper = new QSignalMapper(this);
    connect(mapper, SIGNAL(mapped(QString)), this, SLOT(folderSelector(QString)));

    QStringList folders = TodoModel::instance()->allFolders();

    foreach (const QString& s, folders) {
        QPushButton *b = new QPushButton();
        connect(b, SIGNAL(clicked()), mapper, SLOT(map()));
        b->setText(s);
        if (s == m_current.folder) {
            b->setEnabled(false);
        }

        mapper->setMapping(b, s );
        hl->addWidget(b);

    }
}


void TaskEditor::folderSelector(const QString& folder)
{
    qDebug() << "moveto" << folder;
    QString old = m_current.folder;
    m_current.folder = folder;
    TodoModel* m = TodoModel::instance();
    m->commitTask(m_current);
    m->doEmitUpdated(old);

    deleteLater();
}
