#ifndef FRONTPAGE_H
#define FRONTPAGE_H

#include <QWidget>
#include <QMainWindow>

#include "ui_frontpage.h"

class QMaemo5ValueButton;

class FolderView;
class TodoModel;

class FrontPage : public QMainWindow {
    Q_OBJECT
public:
    explicit FrontPage(QWidget *parent = 0);
    ~FrontPage();

    void setModel(TodoModel* mdl);

public Q_SLOTS:
    void addClicked();

    void folderSelector(const QString& folder);
    void itemSelected(QListWidgetItem* item);

    void folderUpdated(const QString& folder);
    void folderSizeUpdated(const QString& folder, int newcount);

protected:
    void changeEvent(QEvent *e);

private:
    void createFolderLinks(QWidget* wdg);

private Q_SLOTS:
    void populate();
private:
    void activateFolder(const QString& foldername);

private:

    QMap<QString, FolderView*> m_folders;    
    QMap<QString, QPushButton*> m_folderSelectors;
    QMaemo5ValueButton* m_catselector;


    //TodoModel* m_td;
    Ui::FrontPage *ui;
};


#endif // FRONTPAGE_H
