#include "categoryeditor.h"
#include "ui_categoryeditor.h"

#include <QInputDialog>
#include <QDebug>
#include "todomodel.h"
CategoryEditor::CategoryEditor(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::CategoryEditor)
{
    ui->setupUi(this);
    connect(ui->btnNewCat, SIGNAL(clicked()), this, SLOT(addCategory()));
    connect(ui->listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(selectCategory(QListWidgetItem*)));
    populate();
}

CategoryEditor::~CategoryEditor()
{
    delete ui;
}

void CategoryEditor::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void CategoryEditor::populate()
{
    TodoModel* m = TodoModel::instance();
    QStringList cats;
    m->listCategories(cats);
    ui->listWidget->clear();
    ui->listWidget->addItem("None");
    foreach(const QString& c, cats) {
        ui->listWidget->addItem(c);
    }


}

void CategoryEditor::addCategory()
{
    QString c = QInputDialog::getText(this, "Enter category", "Cat");

    qDebug() << "got " << c;

    TodoModel* m = TodoModel::instance();
    m->createCategory(c);
    populate();

}

void CategoryEditor::selectCategory(QListWidgetItem *item)
{
    emit categorySelected(item->text());
    deleteLater();
}
