//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QDateTime>
#include <QTimer>
#ifdef Q_WS_MAEMO_5
    #include <QDBusMessage>
    #include <QDBusConnection>
    #include <QDBusInterface>
#endif
#include "batterywidget.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0, QString appletId="");
    ~MainWindow();

    bool x11Event(XEvent * event);
    QString GetAppletId();

private:    
    Ui::MainWindow *ui;

    bool m_Pressed;
    BatteryWidget* m_PbCharge;

    QTimer* m_Timer;
    bool m_Bq27x00;
    QColor m_BackgroundColor;
    QString m_AppletId;

    bool m_WasCharging;
    float m_LastPercentage;
    QDateTime m_LastPercentageTime;
    int m_LastRemainingSecs;

    void ApplySettings();
    float GetValue(QString file);
    void SizeToFit();

    float GetTemperature();
    float GetPowerConsumption();

protected:
    void paintEvent(QPaintEvent *event);
    void closeEvent(QCloseEvent *event);
    void mousePressEvent(QMouseEvent* event);
    void mouseReleaseEvent(QMouseEvent* event);

public slots:
    void showSettingsDialog();
    void BmePropertyModifiedSlot(QDBusMessage);
    void ChargingTimerSlot();
    void DisplayStateChangedSlot(QString displayState);

};

#endif // MAINWINDOW_H
