/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtDeclarative module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QMLGRAPHICSTEXTINPUT_P_H
#define QMLGRAPHICSTEXTINPUT_P_H

#include "qmlgraphicstextinput_p.h"

#include "qmlgraphicspainteditem_p_p.h"

#include <qml.h>

#include <QPointer>

#include <private/qlinecontrol_p.h>

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.

QT_BEGIN_NAMESPACE

class QmlGraphicsTextInputPrivate : public QmlGraphicsPaintedItemPrivate
{
    Q_DECLARE_PUBLIC(QmlGraphicsTextInput)
public:
    QmlGraphicsTextInputPrivate() : control(new QLineControl(QString())),
                 color((QRgb)0), style(QmlGraphicsText::Normal),
                 styleColor((QRgb)0), hAlign(QmlGraphicsTextInput::AlignLeft),
                 hscroll(0), oldScroll(0), focused(false), focusOnPress(true),
                 cursorVisible(false)
    {
    }

    ~QmlGraphicsTextInputPrivate()
    {
        delete control;
    }

    void init();
    void startCreatingCursor();

    QLineControl* control;

    QFont font;
    QColor  color;
    QColor  selectionColor;
    QColor  selectedTextColor;
    QmlGraphicsText::TextStyle style;
    QColor  styleColor;
    QmlGraphicsTextInput::HAlignment hAlign;
    QPointer<QmlComponent> cursorComponent;
    QPointer<QmlGraphicsItem> cursorItem;

    int lastSelectionStart;
    int lastSelectionEnd;
    int oldHeight;
    int oldWidth;
    bool oldValidity;
    int hscroll;
    int oldScroll;
    bool focused;
    bool focusOnPress;
    bool cursorVisible;
};

QT_END_NAMESPACE

#endif

