# Work as a module:
!mac:QMAKE_LIBDIR+=$$QMAKE_LIBDIR_QT
!mac:QMAKE_LIBDIR_QT=../../lib
TARGET     = QtDeclarative
QPRO_PWD   = $$PWD
QT         = core gui xml script network
contains(QT_CONFIG, svg): QT += svg
contains(QT_CONFIG, opengl): QT += opengl
DEFINES   += QT_BUILD_DECLARATIVE_LIB
win32-msvc*|win32-icc:QMAKE_LFLAGS += /BASE:0x66000000
solaris-cc*:QMAKE_CXXFLAGS_RELEASE -= -O2

unix:QMAKE_PKGCONFIG_REQUIRES = QtCore QtGui QtXml

exists("qml_enable_gcov") {
    QMAKE_CXXFLAGS = -fprofile-arcs -ftest-coverage -fno-elide-constructors
    LIBS += -lgcov
}

include(../qbase.pri)

#INCLUDEPATH -= $$QMAKE_INCDIR_QT/$$TARGET
#DESTDIR=.

#modules
include(3rdparty/3rdparty.pri)
include(util/util.pri)
include(graphicsitems/graphicsitems.pri)
include(qml/qml.pri)
include(widgets/widgets.pri)
include(debugger/debugger.pri)

symbian:TARGET.UID3=0x2001E623
mac:CONFIG -= qt_no_framework_direct_includes
OBJECTS_DIR=.obj
DESTDIR=.obj
INCLUDEPATH += ../../include/QtDeclarative
!mac:INCLUDEPATH -= $$QMAKE_INCDIR_QT/$$TARGET
unix:!symbian {
   CONFIG     += create_prl
}
