/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtDeclarative module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QMLINFO_H
#define QMLINFO_H

#include <QtCore/qdebug.h>

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

QT_MODULE(Declarative)

class Q_DECLARATIVE_EXPORT QmlInfo : public QDebug
{
public:
    QmlInfo(const QObject *);
    ~QmlInfo();

    inline QmlInfo &operator<<(QChar t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(QBool t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(bool t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(char t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(signed short t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(unsigned short t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(signed int t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(unsigned int t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(signed long t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(unsigned long t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(qint64 t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(quint64 t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(float t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(double t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(const char* t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(const QString & t) { QDebug::operator<<(t.toLocal8Bit().constData()); return *this; }
    inline QmlInfo &operator<<(const QStringRef & t) { return operator<<(t.toString()); }
    inline QmlInfo &operator<<(const QLatin1String &t) { QDebug::operator<<(t.latin1()); return *this; }
    inline QmlInfo &operator<<(const QByteArray & t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(const void * t) { QDebug::operator<<(t); return *this; }
    inline QmlInfo &operator<<(QTextStreamFunction f) { QDebug::operator<<(f); return *this; }
    inline QmlInfo &operator<<(QTextStreamManipulator m) { QDebug::operator<<(m); return *this; }
};

Q_DECLARATIVE_EXPORT inline QmlInfo qmlInfo(const QObject *me)
{
    return QmlInfo(me);
}

QT_END_NAMESPACE

QT_END_HEADER

#endif // QMLINFO_H
