/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/
#include "lineedit.h"
#include <qml.h>

LineEditExtension::LineEditExtension(QObject *object)
: QObject(object), m_lineedit(static_cast<QLineEdit *>(object))
{
}

int LineEditExtension::leftMargin() const
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    return l;
}

void LineEditExtension::setLeftMargin(int m)
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    m_lineedit->setTextMargins(m, t, r, b);
}

int LineEditExtension::rightMargin() const
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    return r;
}

void LineEditExtension::setRightMargin(int m) 
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    m_lineedit->setTextMargins(l, t, m, b);
}

int LineEditExtension::topMargin() const
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    return t;
}

void LineEditExtension::setTopMargin(int m) 
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    m_lineedit->setTextMargins(l, m, r, b);
}

int LineEditExtension::bottomMargin() const
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    return b;
}

void LineEditExtension::setBottomMargin(int m) 
{
    int l, r, t, b;
    m_lineedit->getTextMargins(&l, &t, &r, &b);
    m_lineedit->setTextMargins(l, t, r, m);
}

QML_DECLARE_TYPE(QLineEdit);
QML_DEFINE_EXTENDED_TYPE(People, 1,0, QLineEdit, QLineEdit, LineEditExtension);
