/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "widget.h"
#include <QSvgRenderer>
#include <QPainter>
#include <QPaintEvent>
#include <QPen>
#include <QBrush>

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>

#include <QtGui/QMessageBox>

Widget::Widget()
    : QWidget(0, Qt::FramelessWindowHint),
      dirty(true)
{
    //To optimize painting a bit you can set the following:
    //   note that child widgets might not be composed
    //   correctly then though
    //setAttribute(Qt::WA_PaintOnScreen);
    //setAttribute(Qt::WA_NoSystemBackground);
   
    QCoreApplication::instance()->setApplicationName("Hildon-Desktop widget example");

    // Get required atoms
    Atom winTypeAtom = XInternAtom(QX11Info::display(), "_NET_WM_WINDOW_TYPE", false);
    Atom homeAppletAto = XInternAtom(QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", false);
    Atom appletIDAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", false);
    Atom utf8Atom = XInternAtom(QX11Info::display(), "UTF8_STRING", false); 
    Atom appletSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", false);
   
    // Set correct window type
    XChangeProperty(QX11Info::display(), winId(), winTypeAtom, XA_ATOM, 32,
		    PropModeReplace, (unsigned char *) &homeAppletAto, 1);

    // Use application name to fill AppletID
    QByteArray id (QCoreApplication::instance()->applicationName().remove(' ').toUtf8());
    XChangeProperty(QX11Info::display(), winId(), appletIDAtom, utf8Atom, 8, 
    	            PropModeReplace, (unsigned char *)id.constData(), id.length());

    // Add setting button. This button is shown when hildon-desktop is in edit mode. 
    int settings = 0;
    XChangeProperty(QX11Info::display(), winId(), appletSettingAtom, XA_CARDINAL, 32,
		    PropModeReplace, (unsigned char*)&settings, 1);
    
    renderer = new QSvgRenderer(QLatin1String("/usr/share/applications/qtexample-hildondesktopwidget/hummingbird.svg"), this);
}


void Widget::paintEvent(QPaintEvent *e)
{
    QPainter p(this);
    p.setRenderHint(QPainter::Antialiasing);
    p.setClipRect(e->rect());

    //make sure you clean your widget with a transparent
    //  color before doing any rendering
    //  note the usage of a composition mode Source
    //  it's important!
    p.save();
    p.setCompositionMode(QPainter::CompositionMode_Source);
    p.fillRect(rect(), Qt::transparent);
    p.restore();
    
    if (dirty) {
        cache.fill(Qt::transparent);
        QPainter p(&cache);
        p.setRenderHint(QPainter::Antialiasing);
        renderer->render(&p);
        p.end();
        dirty = false;
    }
    p.drawPixmap(0, 0, cache);
        
}

//Filter show setting requests
bool QWidget::x11Event ( XEvent * event )
{
  static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);

  if (event->xclient.message_type == appletShowSettingAtom ) { 
      QMessageBox::information(0, "Setting Dialog example", "Here your settings", QMessageBox::Ok, QMessageBox::Ok);
      return true;
  }
  return false;
}

void Widget::resizeEvent(QResizeEvent *e)
{
    if (e->size() != cache.size()) {
        cache = QPixmap(e->size());
        dirty = true;
        int w = e->size().width();
        int h = e->size().height();
	Q_UNUSED(w);
	Q_UNUSED(h);
    }
}

