/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Components project on Qt Labs.
**
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions contained
** in the Technology Preview License Agreement accompanying this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
****************************************************************************/

import Qt 4.7
import com.meego 1.0

Item {
    width: 400
    height: 400

    Column {
        x: 50
        y: 25

        spacing: 100

        Row {
            spacing: 15

            ButtonRow {
                groupType: "Many"

                Button {
                    id: toggleUnknown
                    text: "Unknown"
                }

                Button {
                    id: smallStyle
                    text: "Small style"
                }
            }

            Spinner {
                id: spinner
                unknownDuration: toggleUnknown.checked
                value: slider.value
                __styleParentClass: smallStyle.checked ? "MContainerHeader" : ""
            }
        }

        Slider {
            id: slider

            width: 300
            visible: !toggleUnknown.checked

            minimumValue: 0
            maximumValue: 100
        }
    }
}
