/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 1.0
import org.hildon.dbus 1.0

/*!
    \class DBusConnections
    \brief Establishes signal connections to a target object via DBus.
    
    \ingroup dbus
*/
Connections {
    id: root
    
    default property QtObject _d
    
    /*!
        type:enumeration
        \brief The bus of the target.
    
        Possible values are:
    
        <table>
            <tr>
                <th>Value</th>
                <th>Description</th>
            </tr>
            <tr>
                <td>DBus.SessionBus</td>
                <td>The target is on the session bus (default).</td>
            </tr>
            <tr>
                <td>DBus.SystemBus</td>
                <td>The target is on the system bus.</td>
            </tr>
        </table>
    */
    property alias bus: d.bus
    
    /*!
        type:bool
        \brief Whether signal connections should be enabled.
        
        The default value is \c true.
    */
    property alias enabled: d.enabled
    
    /*!
        type:string
        \brief The DBus interface name of the target.
    */
    property alias interfaceName: d.interfaceName
    
    /*!
        type:string
        \brief The DBus path of the target.
    */
    property alias path: d.path
    
    /*!
        type:string
        \brief The DBus service name of the target.
    */
    property alias serviceName: d.serviceName
    
    /*!
        \internal
        
        This should not be changed.
    */
    target: null
    ignoreUnknownSignals: true
    
    DBusConnectionsPrivate {
        id: d
        
        onReady: root.target = d
    }    
}
