/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef QCHDBUSADAPTOR_H
#define QCHDBUSADAPTOR_H

#include "qchdbus.h"
#include <QObject>
#include <QDBusAbstractAdaptor>
#include <QDeclarativeParserStatus>
#include <qdeclarative.h>

class QchDBusAdaptorPrivate;
class QchDBusAdaptorInternalPrivate;

class QchDBusAdaptor : public QObject, public QDeclarativeParserStatus
{
    Q_OBJECT

    Q_PROPERTY(QchDBus::BusType bus READ bus WRITE setBus NOTIFY busChanged)
    Q_PROPERTY(bool enabled READ isEnabled WRITE setEnabled NOTIFY enabledChanged)
    Q_PROPERTY(QString interfaceName READ interfaceName WRITE setInterfaceName NOTIFY interfaceNameChanged)
    Q_PROPERTY(QString path READ path WRITE setPath NOTIFY pathChanged)
    Q_PROPERTY(QString serviceName READ serviceName WRITE setServiceName NOTIFY serviceNameChanged)
    Q_PROPERTY(QString xml READ xml WRITE setXml NOTIFY xmlChanged)
    
    Q_INTERFACES(QDeclarativeParserStatus)

public:
    explicit QchDBusAdaptor(QObject *parent = 0);
    ~QchDBusAdaptor();

    QchDBus::BusType bus() const;
    void setBus(QchDBus::BusType b);
    
    bool isEnabled() const;
    void setEnabled(bool enabled);
    
    QString interfaceName() const;
    void setInterfaceName(const QString &name);

    QString path() const;
    void setPath(const QString &path);
    
    QString serviceName() const;
    void setServiceName(const QString &name);
    
    QString xml() const;
    void setXml(const QString &x);

Q_SIGNALS:
    void busChanged();
    void enabledChanged();
    void interfaceNameChanged();
    void pathChanged();
    void serviceNameChanged();
    void xmlChanged();
    
protected:
    QchDBusAdaptor(QchDBusAdaptorPrivate &dd, QObject *parent = 0);

    virtual void classBegin();
    virtual void componentComplete();

    QScopedPointer<QchDBusAdaptorPrivate> d_ptr;

    Q_DECLARE_PRIVATE(QchDBusAdaptor)

private:
    Q_DISABLE_COPY(QchDBusAdaptor)
};

class QchDBusAdaptorInternal : public QObject
{

public:
    explicit QchDBusAdaptorInternal(QchDBusAdaptor *parent = 0);
    ~QchDBusAdaptorInternal();
    
    virtual const QMetaObject* metaObject() const;
    
private:
    void handleMessage(const QDBusMessage &message) const;
    
    virtual int qt_metacall(QMetaObject::Call call, int methodId, void **arguments);
    
    QScopedPointer<QchDBusAdaptorInternalPrivate> d_ptr;
    
    Q_DECLARE_PRIVATE(QchDBusAdaptorInternal)
    Q_DISABLE_COPY(QchDBusAdaptorInternal)
};

QML_DECLARE_TYPE(QchDBusAdaptor)

#endif // QCHDBUSADAPTOR_H
