/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef WEBSETTINGS_P_H
#define WEBSETTINGS_P_H

class WebSettings
{

    Q_PROPERTY(bool autoLoadImages READ autoLoadImages WRITE setAutoLoadImages)
    Q_PROPERTY(bool javascriptCanAccessClipboard READ javascriptCanAccessClipboard WRITE setJavascriptCanAccessClipboard)
    Q_PROPERTY(bool javascriptCanOpenWindows READ javascriptCanOpenWindows WRITE setJavascriptCanOpenWindows)
    Q_PROPERTY(bool javascriptEnabled READ javascriptEnabled WRITE setJavascriptEnabled)
    Q_PROPERTY(bool linksIncludedInFocusChain READ linksIncludedInFocusChain WRITE setLinksIncludedInFocusChain)
    Q_PROPERTY(bool localContentCanAccessRemoteUrls READ localContentCanAccessRemoteUrls WRITE setLocalContentCanAccessRemoteUrls)
    Q_PROPERTY(bool localStorageEnabled READ localStorageEnabled WRITE setLocalStorageEnabled)
    Q_PROPERTY(bool offlineStorageDatabaseEnabled READ offlineStorageDatabaseEnabled WRITE setOfflineStorageDatabaseEnabled)
    Q_PROPERTY(bool offlineWebApplicationCacheEnabled READ offlineWebApplicationCacheEnabled 
                    WRITE setOfflineWebApplicationCacheEnabled)
    Q_PROPERTY(bool persistentStorageEnabled READ persistentStorageEnabled WRITE setPersistentStorageEnabled)
    Q_PROPERTY(bool pluginsEnabled READ pluginsEnabled WRITE setPluginsEnabled)
    Q_PROPERTY(bool printElementBackgrounds READ printElementBackgrounds WRITE setPrintElementBackgrounds)
    Q_PROPERTY(bool privateBrowsingEnabled READ privateBrowsingEnabled WRITE setPrivateBrowsingEnabled)
    Q_PROPERTY(bool zoomTextOnly READ zoomTextOnly WRITE setZoomTextOnly)
    Q_PROPERTY(bool developerExtrasEnabled READ developerExtrasEnabled WRITE setDeveloperExtrasEnabled)
    Q_PROPERTY(string defaultTextEncoding READ defaultTextEncoding WRITE setDefaultTextEncoding)
    Q_PROPERTY(int defaultFixedFontSize READ defaultFixedFontSize WRITE setDefaultFixedFontSize)
    Q_PROPERTY(int defaultFontSize READ defaultFontSize WRITE setDefaultFontSize)
    Q_PROPERTY(int minimumFontSize READ minimumFontSize WRITE setMinimumFontSize)
    Q_PROPERTY(int minimumLogicalFontSize READ minimumLogicalFontSize WRITE setMinimumLogicalFontSize)
    Q_PROPERTY(string cursiveFontFamily READ cursiveFontFamily WRITE setCursiveFontFamily)
    Q_PROPERTY(string fantasyFontFamily READ fantasyFontFamily WRITE setFantasyFontFamily)
    Q_PROPERTY(string fixedFontFamily READ fixedFontFamily WRITE setFixedFontFamily)
    Q_PROPERTY(string sansSerifFontFamily READ sansSerifFontFamily WRITE setSansSerifFontFamily)
    Q_PROPERTY(string serifFontFamily READ serifFontFamily WRITE setSerifFontFamily)
    Q_PROPERTY(string standardFontFamily READ standardFontFamily WRITE setStandardFontFamily)
    Q_PROPERTY(url userStyleSheetUrl READ userStyleSheetUrl WRITE setUserStyleSheetUrl)

/*!
    \class WebSettings
    \brief The WebSettings components provides access to the settings of 
    a WebPage or WebView
    
    \ingroup org-hildon-webkit
    \ingroup org-hildon-webkit-properties
    
    In addition, there is a 'webSettings' global content property that 
    provides access to the global web settings.
    
    \note This component cannot be created in QML.
    
    \sa WebPage, WebView
*/

/*!
    \property bool WebSettings::autoLoadImages
    \brief Whether images are automatically loaded in 
    web pages
    
    This is enabled by default.
*/

/*!
    \property bool WebSettings::javascriptCanAccessClipboard
    \brief Whether JavaScript code can access the system clipboard
*/

/*!
    \property bool WebSettings::javascriptCanOpenWindows
    \brief Whether JavaScript code can open new windows
*/

/*!
    \property bool WebSettings::javascriptEnabled
    \brief Whether JavaScript is enabled
    
    This is enabled by default.
*/

/*!
    \property bool WebSettings::linksIncludedInFocusChain
    \brief Whether hyperlinks should be included in the 
    keyboard focus chain
    
    This is enabled by default.
*/

/*!
    \property bool WebSettings::localContentCanAccessRemoteUrls
    \brief  Whether locally loaded documents are allowed to access 
    remote urls
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::localStorageEnabled
    \brief Whether support for the HTML 5 local storage feature 
    is enabled or not
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::offlineStorageDatabaseEnabled
    \brief Whether support for the HTML 5 offline storage feature 
    is enabled or not
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::offlineWebApplicationCacheEnabled
    \brief Whether support for the HTML 5 web application cache feature 
    is enabled or not
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::persistentStorageEnabled
    \brief Whether persisent settings storage is enabled or not
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::pluginsEnabled
    \brief Whether plugins are enabled in web pages
    
    Qt plugins with a mimetype such as "application/x-qt-plugin" are not 
    affected by this setting. 
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::printElementBackgrounds
    \brief Whether the background color and images are also drawn 
    when the page is printed
    
    This is enabled by default.
*/

/*!
    \property bool WebSettings::privateBrowsingEnabled
    \brief Whether WebKit is prevented from recording visited pages 
    in the history and storing web page icons
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::zoomTextOnly
    \brief Whether the zoom factor on a frame applies
    only to the text or to all content
    
    This is disabled by default.
*/

/*!
    \property bool WebSettings::developerExtrasEnabled
    \brief Whether extra tools are enabled for web developers
    
    This is disabled by default.
*/

/*!
    \property string WebSettings::defaultTextEncoding
    \brief The default text encoding system
*/

/*!
    \property int WebSettings::defaultFixedFontSize
    \brief The default font size for fixed-pitch text
*/

/*!
    \property int WebSettings::defaultFontSize
    \brief The default font size for regular text
*/

/*!
    \property int WebSettings::minimumFontSize
    \brief The hard minimum font size
*/

/*!
    \property int WebSettings::minimumLogicalFontSize
    \brief The minimum logical font size that is applied
    when zooming out
*/

/*!
    \property string WebSettings::cursiveFontFamily
    \brief The font family used for cursive font
*/

/*!
    \property string WebSettings::fantasyFontFamily
    \brief The font family used for fantasy font
*/

/*!
    \property string WebSettings::fixedFontFamily
    \brief The font family used for fixed font
*/

/*!
    \property string WebSettings::sansSerifFontFamily
    \brief The font family used for sans-serif font
*/

/*!
    \property string WebSettings::serifFontFamily
    \brief The font family used for serif font
*/

/*!
    \property string WebSettings::standardFontFamily
    \brief The font family used for standard font
*/

/*!
    \property url WebSettings::userStyleSheetUrl
    \brief The location of a user stylesheet to load with every web page

    The \a location must be either a path on the local filesystem, or a data URL
    with UTF-8 and Base64 encoded data, such as:

    "data:text/css;charset=utf-8;base64,cCB7IGJhY2tncm91bmQtY29sb3I6IHJlZCB9Ow=="

    \note If the base64 data is not valid, the style will not be applied.
*/

};

#endif // WEBSETTINGS_P_H
