/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SCREENSAVER_P_H
#define SCREENSAVER_P_H

class ScreenSaver
{
    Q_OBJECT

    Q_PROPERTY(bool screenSaverInhibited READ screenSaverInhibited WRITE setScreenSaverInhibited)

/*!
    \class ScreenSaver
    \brief The ScreenSaver component controls display dimming
    
    \ingroup org-hildon-utils
    
    \code
    Page {
        windowTitle: "Screen saver page"
        
        CheckBox {
            anchors.centerIn: parent
            text: "Prevent display dimming"
            onCheckedChanged: screenSaver.screenSaverInhibited = checked
        }
        
        ScreenSaver {
            id: screenSaver
        }
    }
    \endcode
*/

/*!
    \property bool ScreenSaver::screenSaverInhibited
    \brief Whether the display should by prevented from dimming
*/

};

#endif // SCREENSAVER_P_H
