/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef DBUSMESSAGE_P_H
#define DBUSMESSAGE_P_H

class DBusMessage
{

    Q_PROPERTY(string serviceName READ serviceName WRITE setServiceName)
    Q_PROPERTY(string path READ path WRITE setPath)
    Q_PROPERTY(string interfaceName READ interfaceName WRITE setInterfaceName)
    Q_PROPERTY(string methodName READ methodName WRITE setMethodName)
    Q_PROPERTY(list<variant> arguments READ arguments WRITE setArguments)
    Q_PROPERTY(enumeration bus READ bus WRITE setBus)
    Q_PROPERTY(enumeration type READ type WRITE setType)
    Q_PROPERTY(enumeration status READ status)
    Q_PROPERTY(variant reply READ reply)
    Q_PROPERTY(string replyString READ replyString)

public:
    void send();
    
/*!
    \class DBusMessage
    \brief The DBusMessage components sends messages via DBus
    
    \ingroup org-hildon-dbus
    
    \code
    DBusMessage {
        id: message
        
        serviceName: "org.maemo.SomeOtherProcess"
        path: "/"
        interfaceName: "org.maemo.SomeOtherProcess"
        methodName: "getSomeProperty"
        arguments: [ "propertyName" ]
        onStatusChanged: {
            switch (status) {
            case DBusMessage.Ready:
                console.log(replyString);
                break;
            case DBusMessage.Error:
                console.log("Error");
                break;
            default:
                break;
            }
        }
    }
    \endcode
*/

/*!
    \property string DBusMessage::serviceName
    \brief The DBus service on which the message will be sent
*/

/*!
    \property string DBusMessage::path
    \brief The DBus path on which the message will be sent
*/

/*!
    \property string DBusMessage::interfaceName
    \brief The DBus interface on which the message will be sent
*/

/*!
    \property string DBusMessage::methodName
    \brief The DBus method to be called
    
    This property is only required if \link type\endlink 
    is \c MethodCallMessage.
    
    \sa type
*/

/*!
    \property list<variant> DBusMessage::arguments
    \brief The DBus arguments to be sent with the message
*/

/*!
    \property enumeration DBusMessage::bus
    \brief The bus on which the which the message will be sent
    
    The possible values are:
    
    \li \c SessionBus
    \li \c SystemBus
    
    The default value is \c SessionBus.
*/

/*!
    \property enumeration DBusMessage::type
    \brief The message type
    
    The possible values are:
    
    \li \c MethodCallMessage
    \li \c SignalMessage
    \li \c ReplyMessage
    \li \c ErrorMessage
    
    The default value is \c MethodCallMessage.
*/

/*!
    \property enumeration DBusMessage::status
    \brief The current status of the message
    
    The possible values are:
    
    \li \c Null
    \li \c Loading
    \li \c Ready
    \li \c Error
    
    The default value is \c Null.
*/

/*!
    \property variant DBusMessage::reply
    \brief The message reply
    
    \sa replyString
*/

/*!
    \property string DBusMessage::replyString
    \brief The messsage reply, formatted as a string
    
    \sa reply
*/

};

#endif // DBUSMESSAGE_P_H
