/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef DBUSCONNECTIONS_P_H
#define DBUSCONNECTIONS_P_H

class DBusConnections : public Connections
{
    
    Q_PROPERTY(Object target READ target)
    Q_PROPERTY(string serviceName READ serviceName WRITE setServiceName)
    Q_PROPERTY(string path READ path WRITE setPath)
    Q_PROPERTY(string interfaceName READ interfaceName WRITE setInterfaceName)
    Q_PROPERTY(enumeration bus READ bus WRITE setBus)
    
/*!
    \class DBusConnections
    \brief The DBusConnections component establishes connections to an object 
    on DBus
    
    \ingroup org-hildon-dbus
    
    \code
    DBusConnections {
        id: connections
        
        serviceName: "org.maemo.SomeOtherProcess"
        path: "/"
        interfaceName: "org.maemo.SomeOtherProcess"
        onSomething: doSomething()
    }
    \endcode
*/

/*!
    \property Object DBusConnections::target
    \brief The target object
*/

/*!
    \property string DBusConnections::serviceName
    \brief The DBus service on which the target exists
*/

/*!
    \property string DBusConnections::path
    \brief The DBus path on which the target exists
*/

/*!
    \property string DBusConnections::interfaceName
    \brief The DBus interface on which the target exists
*/

/*!
    \property enumeration DBusConnections::bus
    \brief The bus on which the target exists
    
    The possible values are:
    
    \li \c SessionBus
    \li \c SystemBus
    
    The default value is \c SessionBus.
*/

};

#endif // DBUSCONNECTIONS_P_H
