/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef VALUEBUTTON_P_H
#define VALUEBUTTON_P_H

class ValueButton : public Button
{

    Q_PROPERTY(ValueSelector selector READ selector WRITE setSelector)
    Q_PROPERTY(string valueText READ valueText WRITE setValueText)
    Q_PROPERTY(enumeration valueLayout READ valueLayout WRITE setValueLayout)

/*!
    \class ValueButton
    \brief The ValueButton component provides a button with two labels.
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-controls
    
    This component is mainly used to implement so called "picker buttons".
    
    It has all the properties of a normal Button, but comes with an
    additional label \link valueText\endlink. This value label
    can be either positioned to the right or below the normal \link text\endlink using
    \link valueLayout \endlink.
    
    If the button is to be used as a picker button then the \link selector \endlink
    property should be used:
    
    \code
     ValueButton {
        id: button

        text: "Selected value"
        selector: ListSelector {
            model: 10
            onSelected: console.log("Value selected: " + text)
        }
    }
    \endcode

    \sa Button, DateSelector, ListSelector, MultiListSelector, TimeSelector
*/

/*!
    \property ValueSelector ValueButton::selector
    \brief The selector assigned to the value button
    
    The selector will be shown when the button is clicked, 
    enabling the user to choose a value.
*/

/*!
    \property enumeration ValueButton::valueLayout
    \brief The layout of the value text relative to the normal text
    
    Possible values are:
    
    \li \c ValueBesideText
    \li \c ValueUnderText
    \li \c ValueUnderTextCentered
    
    The default value is ValueUnderText.

    \sa valueText, selector
*/

/*!
    \property string ValueButton::valueText
    \brief The value text shown on the button

    The default value is an empty string.
    
    \sa valueLayout, selector
*/

};

#endif // VALUEBUTTON_P_H
