/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TOOLBARSTYLE_P_H
#define TOOLBARSTYLE_P_H

class ToolBarStyle : public Style
{
    
    Q_PROPERTY(Style handle READ handle WRITE setHandle)
    Q_PROPERTY(Style separator READ separator WRITE setSeparator)
    
/*!
    \class ToolBarStyle
    \brief ToolBar is a styling component for ToolBar
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa ToolBar
*/

/*!
    \property Style ToolBarStyle::handle
    \brief Applies styling properties to the handle of the ToolBar
*/

/*!
    \property Style ToolBarStyle::separator
    \brief Applies styling properties to the separator of the ToolBar
*/

};

#endif // TOOLBARSTYLE_P_H

