/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TIMESELECTOR_P_H
#define TIMESELECTOR_P_H

class TimeSelector
{

    Q_PROPERTY(int minuteStep READ minuteStep WRITE setMinuteStep)
    Q_PROPERTY(time currentTime READ currentTime WRITE setCurrentTime)
    Q_PROPERTY(string currentValueText READ currentValueText)

signals:
    void selected(string text);

/*!
    \class TimeSelector
    \brief The TimeSelector component provides a time selector for use with 
    the ValueButton component.

    \ingroup org-hildon-components
    \ingroup org-hildon-components-dialogs
    
    When the ValueButton is clicked, the TimeSelector dialog will be shown, 
    allowing the user to choose a time value. The valueText property of the 
    ValueButton will be updated accordingly.
    
    \code
     ValueButton {
        id: button

        text: "Selected time"
        selector: TimeSelector {
            onSelected: console.log("Value selected: " + text)
        }
    }
    \endcode
    
    \sa ValueButton
*/

/*!
    \property int TimeSelector::minuteStep
    \brief The step between values in the minute column 
    of the selector
*/

/*!
    \property time TimeSelector::currentTime
    
    The time currently selected. This can also be 
    changed programmatically.
*/

/*!
    \property string TimeSelector::currentValueText
    
    The currently selected time formatted as a string.
*/

/*!
    \fn void TimeSelector::selected(string text)
    
    This signal is emitted when the user selects the time. 
    The \a text passed is the same as currentValueText.
    
    \sa currentValueText
*/
};

#endif // TIMESELECTOR_P_H
