/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SLIDERSTYLE_P_H
#define SLIDERSTYLE_P_H

class SliderStyle : public Style
{
    
    Q_PROPERTY(Style groove READ groove WRITE setGroove)
    Q_PROPERTY(Style handle READ handle WRITE setHandle)
    
/*!
    \class SliderStyle
    \brief SliderStyle is a styling component for Slider
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-style
    
    \sa Slider
*/

/*!
    \property Style SliderStyle::groove
    \brief Applies styling properties the the groove of a Slider
*/

/*!
    \property Style SliderStyle::handle
    \brief Applies styling properties the the handle of a Slider
*/

};

#endif // SLIDERSTYLE_P_H

