/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef RECTANGLE_P_H
#define RECTANGLE_P_H

class Rectangle : public Item
{

    Q_PROPERTY(color color READ color WRITE setColor)
    Q_PROPERTY(real radius READ radius WRITE setRadius)
    Q_PROPERTY(bool smooth READ smooth WRITE setSmooth)
    Q_PROPERTY(Border border READ border CONSTANT)
    Q_PROPERTY(Gradient gradient READ gradient WRITE setGradient)

/*!
    \class Rectangle
    \brief The Rectangle component is used for displaying rectangles
    
    \ingroup org-hildon-components
    \ingroup org-hildon-components-graphics
*/

/*!
    \property color Rectangle::color
    \brief The color of the rectangle
*/

/*!
    \property real Rectangle::radius
    \brief The radius of the rectangle
*/

};

#endif // RECTANGLE_P_H
